# This file was auto-generated by Fern from our API Definition.

from .base_patient import BasePatient
from ....fhir.types.address import Address
from ....fhir.types.age import Age
from ....fhir.types.annotation import Annotation
from ....fhir.types.attachment import Attachment
from ....fhir.types.codeable_concept import CodeableConcept
from ....fhir.types.coding import Coding
from ....fhir.types.contact_detail import ContactDetail
from ....fhir.types.contact_point import ContactPoint
from ....fhir.types.contributor import Contributor
from ....fhir.types.count import Count
from ....fhir.types.data_requirement import DataRequirement
from ....fhir.types.data_requirement_code_filter import DataRequirementCodeFilter
from ....fhir.types.data_requirement_date_filter import DataRequirementDateFilter
from ....fhir.types.data_requirement_sort import DataRequirementSort
from ....fhir.types.distance import Distance
from ....fhir.types.dosage import Dosage
from ....fhir.types.dosage_dose_and_rate import DosageDoseAndRate
from ....fhir.types.duration import Duration
from ....fhir.types.expression import Expression
from ....fhir.types.extension import Extension
from ....fhir.types.human_name import HumanName
from ....fhir.types.identifier import Identifier
from ....fhir.types.meta import Meta
from ....fhir.types.money import Money
from ....fhir.types.parameter_definition import ParameterDefinition
from ....fhir.types.period import Period
from ....fhir.types.quantity import Quantity
from ....fhir.types.range import Range
from ....fhir.types.ratio import Ratio
from ....fhir.types.reference import Reference
from ....fhir.types.related_artifact import RelatedArtifact
from ....fhir.types.sampled_data import SampledData
from ....fhir.types.signature import Signature
from ....fhir.types.timing import Timing
from ....fhir.types.timing_repeat import TimingRepeat
from ....fhir.types.trigger_definition import TriggerDefinition
from ....fhir.types.usage_context import UsageContext
import pydantic
import typing_extensions
import typing
from .facility_id import FacilityId
from ....core.serialization import FieldMetadata
from ....core.pydantic_utilities import IS_PYDANTIC_V2


class Patient(BasePatient):
    """
    Examples
    --------
    from metriport.commons import Address
    from metriport.medical.patient import Patient, PersonalIdentifier_DriversLicense

    Patient(
        id="018a80c4-292a-7486-a1234-76yuhe23yu14",
        first_name="Karen",
        last_name="Lynch",
        dob="1963-12-30",
        gender_at_birth="F",
        personal_identifiers=[
            PersonalIdentifier_DriversLicense(
                state="CA",
                value="51227265",
            )
        ],
        address=[
            Address(
                address_line_1="2261 Market Street",
                address_line_2="#4818",
                city="San Francisco",
                state="CA",
                zip="94114",
                country="USA",
            )
        ],
        facility_ids=["2.16.840.1.113883.3.666.5.2004.4.2005"],
    )
    """

    id: str = pydantic.Field()
    """
    The ID assigned to this Patient. This ID will be used to uniquely
    identify this Patient in medical documents.
    """

    facility_ids: typing_extensions.Annotated[
        typing.List[FacilityId], FieldMetadata(alias="facilityIds")
    ] = pydantic.Field()
    """
    Array of the IDs of the Facilities where the Patient is receiving care.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
