# This file was auto-generated by Fern from our API Definition.

from ....core.pydantic_utilities import UniversalBaseModel
from ....fhir.types.address import Address as fhir_types_address_Address
from ....fhir.types.age import Age
from ....fhir.types.annotation import Annotation
from ....fhir.types.attachment import Attachment
from ....fhir.types.codeable_concept import CodeableConcept
from ....fhir.types.coding import Coding
from ....fhir.types.contact_detail import ContactDetail
from ....fhir.types.contact_point import ContactPoint
from ....fhir.types.contributor import Contributor
from ....fhir.types.count import Count
from ....fhir.types.data_requirement import DataRequirement
from ....fhir.types.data_requirement_code_filter import DataRequirementCodeFilter
from ....fhir.types.data_requirement_date_filter import DataRequirementDateFilter
from ....fhir.types.data_requirement_sort import DataRequirementSort
from ....fhir.types.distance import Distance
from ....fhir.types.dosage import Dosage
from ....fhir.types.dosage_dose_and_rate import DosageDoseAndRate
from ....fhir.types.duration import Duration
from ....fhir.types.expression import Expression
from ....fhir.types.extension import Extension
from ....fhir.types.human_name import HumanName
from ....fhir.types.identifier import Identifier
from ....fhir.types.meta import Meta
from ....fhir.types.money import Money
from ....fhir.types.parameter_definition import ParameterDefinition
from ....fhir.types.period import Period
from ....fhir.types.quantity import Quantity
from ....fhir.types.range import Range
from ....fhir.types.ratio import Ratio
from ....fhir.types.reference import Reference
from ....fhir.types.related_artifact import RelatedArtifact
from ....fhir.types.sampled_data import SampledData
from ....fhir.types.signature import Signature
from ....fhir.types.timing import Timing
from ....fhir.types.timing_repeat import TimingRepeat
from ....fhir.types.trigger_definition import TriggerDefinition
from ....fhir.types.usage_context import UsageContext
import typing_extensions
from ....core.serialization import FieldMetadata
import pydantic
import typing
from .personal_identifier import PersonalIdentifier
from ....commons.types.address import Address as commons_types_address_Address
from .contact import Contact
from ....core.pydantic_utilities import IS_PYDANTIC_V2


class Demographics(UniversalBaseModel):
    first_name: typing_extensions.Annotated[str, FieldMetadata(alias="firstName")] = (
        pydantic.Field()
    )
    """
    The Patient's first name(s).
    You may provide a comma/space delimited string to specify
    multiple first and last names. For example, the following inputs
    would be equivalent: "John,Jonathan" & "John Jonathan"
    """

    last_name: typing_extensions.Annotated[str, FieldMetadata(alias="lastName")] = (
        pydantic.Field()
    )
    """
    The Patient's last name(s).
    """

    dob: str = pydantic.Field()
    """
    The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.
    """

    gender_at_birth: typing_extensions.Annotated[
        str, FieldMetadata(alias="genderAtBirth")
    ] = pydantic.Field()
    """
    The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.
    """

    personal_identifiers: typing_extensions.Annotated[
        typing.Optional[typing.List[PersonalIdentifier]],
        FieldMetadata(alias="personalIdentifiers"),
    ] = pydantic.Field(default=None)
    """
    An array of the Patient's personal IDs, such as a driver's license.
    May be empty.
    """

    address: typing.List[commons_types_address_Address]
    contact: typing.Optional[typing.List[Contact]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
