# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...commons.types.address import Address
from .types.personal_identifier import PersonalIdentifier
from .types.contact import Contact
from ...core.request_options import RequestOptions
from .types.patient import Patient
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...core.jsonable_encoder import jsonable_encoder
from .types.list_patients_response import ListPatientsResponse
from .types.medical_record_status import MedicalRecordStatus
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PatientClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        facility_id: str,
        first_name: str,
        last_name: str,
        dob: str,
        gender_at_birth: str,
        address: typing.Sequence[Address],
        external_id: typing.Optional[str] = OMIT,
        personal_identifiers: typing.Optional[
            typing.Sequence[PersonalIdentifier]
        ] = OMIT,
        contact: typing.Optional[typing.Sequence[Contact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Creates a Patient in Metriport for the specified Facility where the patient is receiving care.
        The more demographic info you can provide about a Patient,
        the higher chances Metriport will be able to find a match.
        For example, nicknames, old addresses, multiple phone numbers,
        a pre-marital last name, etc.

        Parameters
        ----------
        facility_id : str
            The ID of the Facility where the Patient is receiving care.

        first_name : str
            The Patient's first name(s).
            You may provide a comma/space delimited string to specify
            multiple first and last names. For example, the following inputs
            would be equivalent: "John,Jonathan" & "John Jonathan"

        last_name : str
            The Patient's last name(s).

        dob : str
            The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.

        gender_at_birth : str
            The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.

        address : typing.Sequence[Address]

        external_id : typing.Optional[str]
            An external Patient ID to associate to a Patient in Metriport.

        personal_identifiers : typing.Optional[typing.Sequence[PersonalIdentifier]]
            An array of the Patient's personal IDs, such as a driver's license.
            May be empty.

        contact : typing.Optional[typing.Sequence[Contact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        from metriport import Metriport
        from metriport.commons import Address
        from metriport.medical.patient import PersonalIdentifier_DriversLicense

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.create(
            facility_id="2.16.840.1.113883.3.666.5.2004.4.2005",
            first_name="Karen",
            last_name="Lynch",
            dob="1963-12-30",
            gender_at_birth="F",
            personal_identifiers=[
                PersonalIdentifier_DriversLicense(
                    state="CA",
                    value="51227265",
                )
            ],
            address=[
                Address(
                    address_line_1="2261 Market Street",
                    address_line_2="#4818",
                    city="San Francisco",
                    state="CA",
                    zip="94114",
                    country="USA",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/patient",
            method="POST",
            params={
                "facilityId": facility_id,
            },
            json={
                "externalId": external_id,
                "firstName": first_name,
                "lastName": last_name,
                "dob": dob,
                "genderAtBirth": gender_at_birth,
                "personalIdentifiers": convert_and_respect_annotation_metadata(
                    object_=personal_identifiers,
                    annotation=typing.Sequence[PersonalIdentifier],
                    direction="write",
                ),
                "address": convert_and_respect_annotation_metadata(
                    object_=address,
                    annotation=typing.Sequence[Address],
                    direction="write",
                ),
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact,
                    annotation=typing.Sequence[Contact],
                    direction="write",
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Patient:
        """
        Get a Patient

        Parameters
        ----------
        id : str
            The ID of the Patient.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.get(
            id="018a80c4-292a-7486-a1234-76yuhe23yu14",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        id: str,
        *,
        facility_id: str,
        first_name: str,
        last_name: str,
        dob: str,
        gender_at_birth: str,
        address: typing.Sequence[Address],
        external_id: typing.Optional[str] = OMIT,
        personal_identifiers: typing.Optional[
            typing.Sequence[PersonalIdentifier]
        ] = OMIT,
        contact: typing.Optional[typing.Sequence[Contact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Updates the specified Patient.

        Parameters
        ----------
        id : str
            The ID of the Patient to update.

        facility_id : str
            The ID of the Facility where the patient is receiving care.

        first_name : str
            The Patient's first name(s).
            You may provide a comma/space delimited string to specify
            multiple first and last names. For example, the following inputs
            would be equivalent: "John,Jonathan" & "John Jonathan"

        last_name : str
            The Patient's last name(s).

        dob : str
            The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.

        gender_at_birth : str
            The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.

        address : typing.Sequence[Address]

        external_id : typing.Optional[str]
            An external Patient ID to associate to a Patient in Metriport.

        personal_identifiers : typing.Optional[typing.Sequence[PersonalIdentifier]]
            An array of the Patient's personal IDs, such as a driver's license.
            May be empty.

        contact : typing.Optional[typing.Sequence[Contact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        from metriport import Metriport
        from metriport.commons import Address
        from metriport.medical.patient import Contact, PersonalIdentifier_DriversLicense

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.update(
            id="string",
            facility_id="string",
            external_id="string",
            first_name="string",
            last_name="string",
            dob="string",
            gender_at_birth="string",
            personal_identifiers=[
                PersonalIdentifier_DriversLicense(
                    state="CA",
                    value="51227265",
                )
            ],
            address=[
                Address(
                    address_line_1="2261 Market Street",
                    address_line_2="#4818",
                    city="San Francisco",
                    state="CA",
                    zip="94114",
                    country="USA",
                )
            ],
            contact=[
                Contact(
                    phone="1234567899",
                    email="karen@cvspharmacy.com",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}",
            method="PUT",
            params={
                "facilityId": facility_id,
            },
            json={
                "externalId": external_id,
                "firstName": first_name,
                "lastName": last_name,
                "dob": dob,
                "genderAtBirth": gender_at_birth,
                "personalIdentifiers": convert_and_respect_annotation_metadata(
                    object_=personal_identifiers,
                    annotation=typing.Sequence[PersonalIdentifier],
                    direction="write",
                ),
                "address": convert_and_respect_annotation_metadata(
                    object_=address,
                    annotation=typing.Sequence[Address],
                    direction="write",
                ),
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact,
                    annotation=typing.Sequence[Contact],
                    direction="write",
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(
        self,
        *,
        facility_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListPatientsResponse:
        """
        Lists all Patients receiving care at the specified Facility, or all Patients if no Facility is specified.

        Parameters
        ----------
        facility_id : typing.Optional[str]
            The ID of the Facility where the patient is receiving care.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListPatientsResponse

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.list(
            facility_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/patient",
            method="GET",
            params={
                "facilityId": facility_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListPatientsResponse,
                    parse_obj_as(
                        type_=ListPatientsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self,
        id: str,
        *,
        facility_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Removes the specified Patient.

        Parameters
        ----------
        id : str
            The ID of the Patient to delete.

        facility_id : typing.Optional[str]
            The ID of the Facility where the patient is receiving care.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.delete(
            id="string",
            facility_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}",
            method="DELETE",
            params={
                "facilityId": facility_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_medical_record_summary(
        self,
        patient_id: str,
        *,
        conversion_type: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> str:
        """
        Returns the URL for a medical record summary

        Parameters
        ----------
        patient_id : str
            The ID of the Patient.

        conversion_type : str
            The type of conversion to perform. `html` or `pdf`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            The URL for the medical record summary

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.get_medical_record_summary(
            patient_id="string",
            conversion_type="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/medical-record",
            method="GET",
            params={
                "conversionType": conversion_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    str,
                    parse_obj_as(
                        type_=str,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_medical_record_summary_status(
        self,
        patient_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MedicalRecordStatus:
        """
        Returns the status of a medical record summary

        Parameters
        ----------
        patient_id : str
            The ID of the Patient.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MedicalRecordStatus
            the status of the medical record summary

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.get_medical_record_summary_status(
            patient_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/medical-record-status",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MedicalRecordStatus,
                    parse_obj_as(
                        type_=MedicalRecordStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def match(
        self,
        *,
        first_name: str,
        last_name: str,
        dob: str,
        gender_at_birth: str,
        address: typing.Sequence[Address],
        personal_identifiers: typing.Optional[
            typing.Sequence[PersonalIdentifier]
        ] = OMIT,
        contact: typing.Optional[typing.Sequence[Contact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Searches for a Patient previously created in Metriport, based on demographic data.

        Parameters
        ----------
        first_name : str
            The Patient's first name(s).
            You may provide a comma/space delimited string to specify
            multiple first and last names. For example, the following inputs
            would be equivalent: "John,Jonathan" & "John Jonathan"

        last_name : str
            The Patient's last name(s).

        dob : str
            The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.

        gender_at_birth : str
            The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.

        address : typing.Sequence[Address]

        personal_identifiers : typing.Optional[typing.Sequence[PersonalIdentifier]]
            An array of the Patient's personal IDs, such as a driver's license.
            May be empty.

        contact : typing.Optional[typing.Sequence[Contact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        from metriport import Metriport
        from metriport.commons import Address
        from metriport.medical.patient import PersonalIdentifier_DriversLicense

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.patient.match(
            first_name="Karen",
            last_name="Lynch",
            dob="1963-12-30",
            gender_at_birth="F",
            personal_identifiers=[
                PersonalIdentifier_DriversLicense(
                    state="CA",
                    value="51227265",
                )
            ],
            address=[
                Address(
                    address_line_1="2261 Market Street",
                    address_line_2="#4818",
                    city="San Francisco",
                    state="CA",
                    zip="94114",
                    country="USA",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/patient/match",
            method="POST",
            json={
                "firstName": first_name,
                "lastName": last_name,
                "dob": dob,
                "genderAtBirth": gender_at_birth,
                "personalIdentifiers": convert_and_respect_annotation_metadata(
                    object_=personal_identifiers,
                    annotation=typing.Sequence[PersonalIdentifier],
                    direction="write",
                ),
                "address": convert_and_respect_annotation_metadata(
                    object_=address,
                    annotation=typing.Sequence[Address],
                    direction="write",
                ),
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact,
                    annotation=typing.Sequence[Contact],
                    direction="write",
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncPatientClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        facility_id: str,
        first_name: str,
        last_name: str,
        dob: str,
        gender_at_birth: str,
        address: typing.Sequence[Address],
        external_id: typing.Optional[str] = OMIT,
        personal_identifiers: typing.Optional[
            typing.Sequence[PersonalIdentifier]
        ] = OMIT,
        contact: typing.Optional[typing.Sequence[Contact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Creates a Patient in Metriport for the specified Facility where the patient is receiving care.
        The more demographic info you can provide about a Patient,
        the higher chances Metriport will be able to find a match.
        For example, nicknames, old addresses, multiple phone numbers,
        a pre-marital last name, etc.

        Parameters
        ----------
        facility_id : str
            The ID of the Facility where the Patient is receiving care.

        first_name : str
            The Patient's first name(s).
            You may provide a comma/space delimited string to specify
            multiple first and last names. For example, the following inputs
            would be equivalent: "John,Jonathan" & "John Jonathan"

        last_name : str
            The Patient's last name(s).

        dob : str
            The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.

        gender_at_birth : str
            The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.

        address : typing.Sequence[Address]

        external_id : typing.Optional[str]
            An external Patient ID to associate to a Patient in Metriport.

        personal_identifiers : typing.Optional[typing.Sequence[PersonalIdentifier]]
            An array of the Patient's personal IDs, such as a driver's license.
            May be empty.

        contact : typing.Optional[typing.Sequence[Contact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport
        from metriport.commons import Address
        from metriport.medical.patient import PersonalIdentifier_DriversLicense

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.create(
                facility_id="2.16.840.1.113883.3.666.5.2004.4.2005",
                first_name="Karen",
                last_name="Lynch",
                dob="1963-12-30",
                gender_at_birth="F",
                personal_identifiers=[
                    PersonalIdentifier_DriversLicense(
                        state="CA",
                        value="51227265",
                    )
                ],
                address=[
                    Address(
                        address_line_1="2261 Market Street",
                        address_line_2="#4818",
                        city="San Francisco",
                        state="CA",
                        zip="94114",
                        country="USA",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/patient",
            method="POST",
            params={
                "facilityId": facility_id,
            },
            json={
                "externalId": external_id,
                "firstName": first_name,
                "lastName": last_name,
                "dob": dob,
                "genderAtBirth": gender_at_birth,
                "personalIdentifiers": convert_and_respect_annotation_metadata(
                    object_=personal_identifiers,
                    annotation=typing.Sequence[PersonalIdentifier],
                    direction="write",
                ),
                "address": convert_and_respect_annotation_metadata(
                    object_=address,
                    annotation=typing.Sequence[Address],
                    direction="write",
                ),
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact,
                    annotation=typing.Sequence[Contact],
                    direction="write",
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Patient:
        """
        Get a Patient

        Parameters
        ----------
        id : str
            The ID of the Patient.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.get(
                id="018a80c4-292a-7486-a1234-76yuhe23yu14",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        id: str,
        *,
        facility_id: str,
        first_name: str,
        last_name: str,
        dob: str,
        gender_at_birth: str,
        address: typing.Sequence[Address],
        external_id: typing.Optional[str] = OMIT,
        personal_identifiers: typing.Optional[
            typing.Sequence[PersonalIdentifier]
        ] = OMIT,
        contact: typing.Optional[typing.Sequence[Contact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Updates the specified Patient.

        Parameters
        ----------
        id : str
            The ID of the Patient to update.

        facility_id : str
            The ID of the Facility where the patient is receiving care.

        first_name : str
            The Patient's first name(s).
            You may provide a comma/space delimited string to specify
            multiple first and last names. For example, the following inputs
            would be equivalent: "John,Jonathan" & "John Jonathan"

        last_name : str
            The Patient's last name(s).

        dob : str
            The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.

        gender_at_birth : str
            The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.

        address : typing.Sequence[Address]

        external_id : typing.Optional[str]
            An external Patient ID to associate to a Patient in Metriport.

        personal_identifiers : typing.Optional[typing.Sequence[PersonalIdentifier]]
            An array of the Patient's personal IDs, such as a driver's license.
            May be empty.

        contact : typing.Optional[typing.Sequence[Contact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport
        from metriport.commons import Address
        from metriport.medical.patient import Contact, PersonalIdentifier_DriversLicense

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.update(
                id="string",
                facility_id="string",
                external_id="string",
                first_name="string",
                last_name="string",
                dob="string",
                gender_at_birth="string",
                personal_identifiers=[
                    PersonalIdentifier_DriversLicense(
                        state="CA",
                        value="51227265",
                    )
                ],
                address=[
                    Address(
                        address_line_1="2261 Market Street",
                        address_line_2="#4818",
                        city="San Francisco",
                        state="CA",
                        zip="94114",
                        country="USA",
                    )
                ],
                contact=[
                    Contact(
                        phone="1234567899",
                        email="karen@cvspharmacy.com",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}",
            method="PUT",
            params={
                "facilityId": facility_id,
            },
            json={
                "externalId": external_id,
                "firstName": first_name,
                "lastName": last_name,
                "dob": dob,
                "genderAtBirth": gender_at_birth,
                "personalIdentifiers": convert_and_respect_annotation_metadata(
                    object_=personal_identifiers,
                    annotation=typing.Sequence[PersonalIdentifier],
                    direction="write",
                ),
                "address": convert_and_respect_annotation_metadata(
                    object_=address,
                    annotation=typing.Sequence[Address],
                    direction="write",
                ),
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact,
                    annotation=typing.Sequence[Contact],
                    direction="write",
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(
        self,
        *,
        facility_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListPatientsResponse:
        """
        Lists all Patients receiving care at the specified Facility, or all Patients if no Facility is specified.

        Parameters
        ----------
        facility_id : typing.Optional[str]
            The ID of the Facility where the patient is receiving care.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListPatientsResponse

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.list(
                facility_id="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/patient",
            method="GET",
            params={
                "facilityId": facility_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListPatientsResponse,
                    parse_obj_as(
                        type_=ListPatientsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self,
        id: str,
        *,
        facility_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Removes the specified Patient.

        Parameters
        ----------
        id : str
            The ID of the Patient to delete.

        facility_id : typing.Optional[str]
            The ID of the Facility where the patient is receiving care.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.delete(
                id="string",
                facility_id="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}",
            method="DELETE",
            params={
                "facilityId": facility_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_medical_record_summary(
        self,
        patient_id: str,
        *,
        conversion_type: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> str:
        """
        Returns the URL for a medical record summary

        Parameters
        ----------
        patient_id : str
            The ID of the Patient.

        conversion_type : str
            The type of conversion to perform. `html` or `pdf`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            The URL for the medical record summary

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.get_medical_record_summary(
                patient_id="string",
                conversion_type="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/medical-record",
            method="GET",
            params={
                "conversionType": conversion_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    str,
                    parse_obj_as(
                        type_=str,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_medical_record_summary_status(
        self,
        patient_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MedicalRecordStatus:
        """
        Returns the status of a medical record summary

        Parameters
        ----------
        patient_id : str
            The ID of the Patient.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MedicalRecordStatus
            the status of the medical record summary

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.get_medical_record_summary_status(
                patient_id="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/medical-record-status",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MedicalRecordStatus,
                    parse_obj_as(
                        type_=MedicalRecordStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def match(
        self,
        *,
        first_name: str,
        last_name: str,
        dob: str,
        gender_at_birth: str,
        address: typing.Sequence[Address],
        personal_identifiers: typing.Optional[
            typing.Sequence[PersonalIdentifier]
        ] = OMIT,
        contact: typing.Optional[typing.Sequence[Contact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Searches for a Patient previously created in Metriport, based on demographic data.

        Parameters
        ----------
        first_name : str
            The Patient's first name(s).
            You may provide a comma/space delimited string to specify
            multiple first and last names. For example, the following inputs
            would be equivalent: "John,Jonathan" & "John Jonathan"

        last_name : str
            The Patient's last name(s).

        dob : str
            The Patient's date of birth (DOB), formatted `YYYY-MM-DD` as per ISO 8601.

        gender_at_birth : str
            The Patient's gender at birth, can be one of `M` or `F` or `O` or `U`. Use `O` (other) when the patient's gender is known but it is not `M` or `F`, i.e intersex or hermaphroditic. Use U (unknown) when the patient's gender is not known.

        address : typing.Sequence[Address]

        personal_identifiers : typing.Optional[typing.Sequence[PersonalIdentifier]]
            An array of the Patient's personal IDs, such as a driver's license.
            May be empty.

        contact : typing.Optional[typing.Sequence[Contact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport
        from metriport.commons import Address
        from metriport.medical.patient import PersonalIdentifier_DriversLicense

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.patient.match(
                first_name="Karen",
                last_name="Lynch",
                dob="1963-12-30",
                gender_at_birth="F",
                personal_identifiers=[
                    PersonalIdentifier_DriversLicense(
                        state="CA",
                        value="51227265",
                    )
                ],
                address=[
                    Address(
                        address_line_1="2261 Market Street",
                        address_line_2="#4818",
                        city="San Francisco",
                        state="CA",
                        zip="94114",
                        country="USA",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/patient/match",
            method="POST",
            json={
                "firstName": first_name,
                "lastName": last_name,
                "dob": dob,
                "genderAtBirth": gender_at_birth,
                "personalIdentifiers": convert_and_respect_annotation_metadata(
                    object_=personal_identifiers,
                    annotation=typing.Sequence[PersonalIdentifier],
                    direction="write",
                ),
                "address": convert_and_respect_annotation_metadata(
                    object_=address,
                    annotation=typing.Sequence[Address],
                    direction="write",
                ),
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact,
                    annotation=typing.Sequence[Contact],
                    direction="write",
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Patient,
                    parse_obj_as(
                        type_=Patient,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
