# This file was auto-generated by Fern from our API Definition.

from ....core.pydantic_utilities import UniversalBaseModel
import typing_extensions
from ....core.serialization import FieldMetadata
import typing
from .conversion_type_fhir import ConversionTypeFhir
from .document_query_status_fhir import DocumentQueryStatusFhir
from ....core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class PatientConsolidatedDataStatus(UniversalBaseModel):
    """
    Examples
    --------
    from metriport.medical.fhir import PatientConsolidatedDataStatus

    PatientConsolidatedDataStatus(
        request_id="00000000-0000-0000-0000-000000000000",
        started_at="2023-07-27T21:29:31.491+00:00",
        date_from="2023-07-27",
        date_to="2024-07-27",
        conversion_type="html",
        status="processing",
    )
    """

    request_id: typing_extensions.Annotated[str, FieldMetadata(alias="requestId")]
    started_at: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="startedAt")
    ] = None
    date_from: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="dateFrom")
    ] = None
    date_to: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="dateTo")
    ] = None
    conversion_type: typing_extensions.Annotated[
        typing.Optional[ConversionTypeFhir], FieldMetadata(alias="conversionType")
    ] = None
    status: DocumentQueryStatusFhir

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
