# This file was auto-generated by Fern from our API Definition.

from ....core.pydantic_utilities import UniversalBaseModel
import typing_extensions
from ....core.serialization import FieldMetadata
import pydantic
import typing
from ....core.pydantic_utilities import IS_PYDANTIC_V2


class ConsolidatedBundleUpload(UniversalBaseModel):
    """
    Examples
    --------
    from metriport.medical.fhir import ConsolidatedBundleUpload

    ConsolidatedBundleUpload(
        resource_type="Bundle",
        type="collection",
        entry=[
            {
                "resource": {
                    "resourceType": "Observation",
                    "code": {"text": "Cancer"},
                    "valueCodeableConcept": {"text": "NEGATIVE"},
                    "status": "final",
                    "category": [
                        {
                            "coding": [
                                {
                                    "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                                    "code": "laboratory",
                                }
                            ]
                        }
                    ],
                }
            }
        ],
    )
    """

    resource_type: typing_extensions.Annotated[
        str, FieldMetadata(alias="resourceType")
    ] = pydantic.Field()
    """
    The resource needs to be “Bundle”
    """

    type: str = pydantic.Field()
    """
    The type needs to be “collection”
    """

    entry: typing.List[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field()
    """
    The entry needs to be an array of FHIR resources.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
