# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from .types.patient_consolidated_data_status import PatientConsolidatedDataStatus
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from .types.get_consolidated_query_status_response import (
    GetConsolidatedQueryStatusResponse,
)
from ...fhir.types.bundle import Bundle
from .types.consolidated_count_response import ConsolidatedCountResponse
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FhirClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def start_consolidated_query(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        conversion_type: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientConsolidatedDataStatus:
        """
        Trigger a consolidated data query for the given patient.
        When executed,
        this endpoint triggers an asynchronous query to retrieve a Patient's consolidated data from the FHIR repository.
        Once the data is consolidated and ready for consumption,
        a webhook request is sent to your configured URL containing the Patient's
        data in FHIR-compliant format,
        based on the parameters used to trigger the query.
        You'll be able to query multiple times for the same Patient which will be added to the queue and
        processed in order. If the parameters are the same as a previous query that is still processing,
        the new query will be ignored and you'll get the status and request ID of the previous one.
        You can check the status of the data query by calling get consolidated data query.
        This endpoint also provides the ability to render a Medical Record Summary
        from the FHIR bundle as a PDF or HTML document. This will be returned via a webhook
        as a FHIR bundle with a DocumentReference resource
        that will contain a URL to retrieve the data from.,

        Parameters
        ----------
        id : str
            The ID of the Patient.

        resources : typing.Optional[str]
            A comma separated, case sensitive list of resources to be returned. If none are provided all
            resources will be included. Metriport will automatically hydrate the initially filtered
            resources with referenced ones to create bundle consistency.

        date_from : typing.Optional[str]
            The start date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no start date filter will be applied.

        date_to : typing.Optional[str]
            The end date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no end date filter will be applied.

        conversion_type : typing.Optional[str]
            The doc type to convert to. Either `html` or `pdf`.

        request : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientConsolidatedDataStatus
            Returns the filters used for this query, in addition to the identifier used by the system to uniquely identify this query (property `requestId`).

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.start_consolidated_query(
            id="00000000-0000-0000-0000-000000000000",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}/consolidated/query",
            method="POST",
            params={
                "resources": resources,
                "dateFrom": date_from,
                "dateTo": date_to,
                "conversionType": conversion_type,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PatientConsolidatedDataStatus,
                    parse_obj_as(
                        type_=PatientConsolidatedDataStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_consolidated_query_status(
        self,
        patient_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetConsolidatedQueryStatusResponse:
        """
        Get the status of querying for patient's consolidated data.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConsolidatedQueryStatusResponse

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.get_consolidated_query_status(
            patient_id="00000000-0000-0000-0000-000000000000",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/consolidated/query",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetConsolidatedQueryStatusResponse,
                    parse_obj_as(
                        type_=GetConsolidatedQueryStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_single_consolidated_query_status(
        self,
        patient_id: str,
        request_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientConsolidatedDataStatus:
        """
        Get the status of a single query for patient's consolidated data.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient

        request_id : str
            The ID of the request to get the status of.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientConsolidatedDataStatus

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.get_single_consolidated_query_status(
            patient_id="00000000-0000-0000-0000-000000000000",
            request_id="00000000-0000-0000-0000-000000000000",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/consolidated/query/{jsonable_encoder(request_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PatientConsolidatedDataStatus,
                    parse_obj_as(
                        type_=PatientConsolidatedDataStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_patient_consolidated(
        self,
        id: str,
        *,
        resource_type: str,
        type: str,
        entry: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Bundle:
        """
        Create Patient's Consolidated Data with a FHIR Bundle.

        Parameters
        ----------
        id : str
            The ID of the Patient

        resource_type : str
            The resource needs to be “Bundle”

        type : str
            The type needs to be “collection”

        entry : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The entry needs to be an array of FHIR resources.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Bundle

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.create_patient_consolidated(
            id="00000000-0000-0000-0000-000000000000",
            resource_type="Bundle",
            type="collection",
            entry=[
                {
                    "resource": {
                        "resourceType": "Observation",
                        "code": {"text": "Cancer"},
                        "valueCodeableConcept": {"text": "NEGATIVE"},
                        "status": "final",
                        "category": [
                            {
                                "coding": [
                                    {
                                        "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                                        "code": "laboratory",
                                    }
                                ]
                            }
                        ],
                    }
                }
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}/consolidated",
            method="PUT",
            json={
                "resourceType": resource_type,
                "type": type,
                "entry": entry,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Bundle,
                    parse_obj_as(
                        type_=Bundle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def count_patient_data(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConsolidatedCountResponse:
        """
        Get a count of a Patient's data per resource.

        Parameters
        ----------
        id : str
            The ID of the Patient

        resources : typing.Optional[str]
            A comma separated, case sensitive list of resources to be returned.
            If none are provided all resources will be included.

        date_from : typing.Optional[str]
            The start date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no start date filter will be applied.

        date_to : typing.Optional[str]
            The end date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no end date filter will be applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConsolidatedCountResponse

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.fhir.count_patient_data(
            id="string",
            resources="string",
            date_from="string",
            date_to="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}/consolidated/count",
            method="GET",
            params={
                "resources": resources,
                "dateFrom": date_from,
                "dateTo": date_to,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConsolidatedCountResponse,
                    parse_obj_as(
                        type_=ConsolidatedCountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFhirClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def start_consolidated_query(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        conversion_type: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientConsolidatedDataStatus:
        """
        Trigger a consolidated data query for the given patient.
        When executed,
        this endpoint triggers an asynchronous query to retrieve a Patient's consolidated data from the FHIR repository.
        Once the data is consolidated and ready for consumption,
        a webhook request is sent to your configured URL containing the Patient's
        data in FHIR-compliant format,
        based on the parameters used to trigger the query.
        You'll be able to query multiple times for the same Patient which will be added to the queue and
        processed in order. If the parameters are the same as a previous query that is still processing,
        the new query will be ignored and you'll get the status and request ID of the previous one.
        You can check the status of the data query by calling get consolidated data query.
        This endpoint also provides the ability to render a Medical Record Summary
        from the FHIR bundle as a PDF or HTML document. This will be returned via a webhook
        as a FHIR bundle with a DocumentReference resource
        that will contain a URL to retrieve the data from.,

        Parameters
        ----------
        id : str
            The ID of the Patient.

        resources : typing.Optional[str]
            A comma separated, case sensitive list of resources to be returned. If none are provided all
            resources will be included. Metriport will automatically hydrate the initially filtered
            resources with referenced ones to create bundle consistency.

        date_from : typing.Optional[str]
            The start date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no start date filter will be applied.

        date_to : typing.Optional[str]
            The end date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no end date filter will be applied.

        conversion_type : typing.Optional[str]
            The doc type to convert to. Either `html` or `pdf`.

        request : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientConsolidatedDataStatus
            Returns the filters used for this query, in addition to the identifier used by the system to uniquely identify this query (property `requestId`).

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.fhir.start_consolidated_query(
                id="00000000-0000-0000-0000-000000000000",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}/consolidated/query",
            method="POST",
            params={
                "resources": resources,
                "dateFrom": date_from,
                "dateTo": date_to,
                "conversionType": conversion_type,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PatientConsolidatedDataStatus,
                    parse_obj_as(
                        type_=PatientConsolidatedDataStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_consolidated_query_status(
        self,
        patient_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetConsolidatedQueryStatusResponse:
        """
        Get the status of querying for patient's consolidated data.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConsolidatedQueryStatusResponse

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.fhir.get_consolidated_query_status(
                patient_id="00000000-0000-0000-0000-000000000000",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/consolidated/query",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetConsolidatedQueryStatusResponse,
                    parse_obj_as(
                        type_=GetConsolidatedQueryStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_single_consolidated_query_status(
        self,
        patient_id: str,
        request_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientConsolidatedDataStatus:
        """
        Get the status of a single query for patient's consolidated data.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient

        request_id : str
            The ID of the request to get the status of.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientConsolidatedDataStatus

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.fhir.get_single_consolidated_query_status(
                patient_id="00000000-0000-0000-0000-000000000000",
                request_id="00000000-0000-0000-0000-000000000000",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(patient_id)}/consolidated/query/{jsonable_encoder(request_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PatientConsolidatedDataStatus,
                    parse_obj_as(
                        type_=PatientConsolidatedDataStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_patient_consolidated(
        self,
        id: str,
        *,
        resource_type: str,
        type: str,
        entry: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Bundle:
        """
        Create Patient's Consolidated Data with a FHIR Bundle.

        Parameters
        ----------
        id : str
            The ID of the Patient

        resource_type : str
            The resource needs to be “Bundle”

        type : str
            The type needs to be “collection”

        entry : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The entry needs to be an array of FHIR resources.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Bundle

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.fhir.create_patient_consolidated(
                id="00000000-0000-0000-0000-000000000000",
                resource_type="Bundle",
                type="collection",
                entry=[
                    {
                        "resource": {
                            "resourceType": "Observation",
                            "code": {"text": "Cancer"},
                            "valueCodeableConcept": {"text": "NEGATIVE"},
                            "status": "final",
                            "category": [
                                {
                                    "coding": [
                                        {
                                            "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                                            "code": "laboratory",
                                        }
                                    ]
                                }
                            ],
                        }
                    }
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}/consolidated",
            method="PUT",
            json={
                "resourceType": resource_type,
                "type": type,
                "entry": entry,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Bundle,
                    parse_obj_as(
                        type_=Bundle,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def count_patient_data(
        self,
        id: str,
        *,
        resources: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConsolidatedCountResponse:
        """
        Get a count of a Patient's data per resource.

        Parameters
        ----------
        id : str
            The ID of the Patient

        resources : typing.Optional[str]
            A comma separated, case sensitive list of resources to be returned.
            If none are provided all resources will be included.

        date_from : typing.Optional[str]
            The start date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no start date filter will be applied.

        date_to : typing.Optional[str]
            The end date (inclusive) for which to filter returned resources -
            formatted `YYYY-MM-DD` as per ISO 8601. If not provided,
            no end date filter will be applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConsolidatedCountResponse

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.fhir.count_patient_data(
                id="string",
                resources="string",
                date_from="string",
                date_to="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/patient/{jsonable_encoder(id)}/consolidated/count",
            method="GET",
            params={
                "resources": resources,
                "dateFrom": date_from,
                "dateTo": date_to,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConsolidatedCountResponse,
                    parse_obj_as(
                        type_=ConsolidatedCountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
