# This file was auto-generated by Fern from our API Definition.

from .base_facility import BaseFacility
import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class Facility(BaseFacility):
    """
    Examples
    --------
    from metriport.commons import Address
    from metriport.medical.facility import Facility

    Facility(
        id="018a80c4-292a-7486-a1234-9uiu76yhe234",
        oid="2.16.840.1.113883.3.666.123.4.101",
        name="Care Facility, LLC",
        npi="1234567891",
        address=Address(
            address_line_1="2261 Market Street",
            address_line_2="#4818",
            city="San Francisco",
            state="CA",
            zip="94114",
            country="USA",
        ),
        tin="12-3456789",
        active=True,
    )
    """

    id: str = pydantic.Field()
    """
    The ID assigned to this Facility. This ID will be used
    to uniquely identify this Facility in medical documents.
    """

    oid: str = pydantic.Field()
    """
    The OID of your facility.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
