# This file was auto-generated by Fern from our API Definition.

from ....core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ....commons.types.address import Address
from ....core.pydantic_utilities import IS_PYDANTIC_V2


class BaseFacility(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    The name of your Facility. This is the actual address where a patient will receive care (can be virtual) - for example `Care Facility, LLC`.
    """

    npi: str = pydantic.Field()
    """
    The 10 digit National Provider Identifier (NPI) that will be used to make requests on behalf of the Facility.
    """

    tin: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Taxpayer Identification Number (TIN) of the Facility.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not this Facility is currently active - this is usually `true`.
    """

    address: Address

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
