# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...commons.types.address import Address
from ...core.request_options import RequestOptions
from .types.facility import Facility
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...core.jsonable_encoder import jsonable_encoder
from .types.list_facilities_response import ListFacilitiesResponse
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FacilityClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        name: str,
        npi: str,
        address: Address,
        tin: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Facility:
        """
        Creates a Facility in Metriport where your patients receive care.

        Parameters
        ----------
        name : str
            The name of your Facility. This is the actual address where a patient will receive care (can be virtual) - for example `Care Facility, LLC`.

        npi : str
            The 10 digit National Provider Identifier (NPI) that will be used to make requests on behalf of the Facility.

        address : Address

        tin : typing.Optional[str]
            The Taxpayer Identification Number (TIN) of the Facility.

        active : typing.Optional[bool]
            Whether or not this Facility is currently active - this is usually `true`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Facility

        Examples
        --------
        from metriport import Metriport
        from metriport.commons import Address

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.facility.create(
            name="Care Facility, LLC",
            npi="1234567891",
            address=Address(
                address_line_1="2261 Market Street",
                address_line_2="#4818",
                city="San Francisco",
                state="CA",
                zip="94114",
                country="USA",
            ),
            tin="12-3456789",
            active=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/facility",
            method="POST",
            json={
                "name": name,
                "npi": npi,
                "tin": tin,
                "active": active,
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=Address, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Facility,
                    parse_obj_as(
                        type_=Facility,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Facility:
        """
        Get a Facility in Metriport where your patients receive care.

        Parameters
        ----------
        id : str
            The ID assigned to this Facility. This ID will be used
            to uniquely identify this Facility in medical documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Facility

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.facility.get(
            id="018a80c4-292a-7486-a1234-9uiu76yhe234",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/facility/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Facility,
                    parse_obj_as(
                        type_=Facility,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: str,
        npi: str,
        address: Address,
        tin: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Facility:
        """
        Updates a Facility in Metriport where your patients receive care.

        Parameters
        ----------
        id : str
            The ID of the Facility.

        name : str
            The name of your Facility. This is the actual address where a patient will receive care (can be virtual) - for example `Care Facility, LLC`.

        npi : str
            The 10 digit National Provider Identifier (NPI) that will be used to make requests on behalf of the Facility.

        address : Address

        tin : typing.Optional[str]
            The Taxpayer Identification Number (TIN) of the Facility.

        active : typing.Optional[bool]
            Whether or not this Facility is currently active - this is usually `true`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Facility

        Examples
        --------
        from metriport import Metriport
        from metriport.commons import Address

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.facility.update(
            id="018a80c4-292a-7486-a1234-9uiu76yhe234",
            name="Care Facility, LLC",
            npi="1234567891",
            address=Address(
                address_line_1="2261 Market Street",
                address_line_2="#4818",
                city="San Francisco",
                state="CA",
                zip="94114",
                country="USA",
            ),
            tin="12-3456789",
            active=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/facility/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "name": name,
                "npi": npi,
                "tin": tin,
                "active": active,
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=Address, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Facility,
                    parse_obj_as(
                        type_=Facility,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListFacilitiesResponse:
        """
        Lists all of your Facilities.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListFacilitiesResponse
            Array of all of the Facilities created under your Organization.

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.facility.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/facility",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListFacilitiesResponse,
                    parse_obj_as(
                        type_=ListFacilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a Facility. Throws 400 if there are patients associated with the Facility.

        Parameters
        ----------
        id : str
            The ID of the Facility.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.facility.delete(
            id="018a80c4-292a-7486-a1234-9uiu76yhe234",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"medical/v1/facility/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFacilityClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        name: str,
        npi: str,
        address: Address,
        tin: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Facility:
        """
        Creates a Facility in Metriport where your patients receive care.

        Parameters
        ----------
        name : str
            The name of your Facility. This is the actual address where a patient will receive care (can be virtual) - for example `Care Facility, LLC`.

        npi : str
            The 10 digit National Provider Identifier (NPI) that will be used to make requests on behalf of the Facility.

        address : Address

        tin : typing.Optional[str]
            The Taxpayer Identification Number (TIN) of the Facility.

        active : typing.Optional[bool]
            Whether or not this Facility is currently active - this is usually `true`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Facility

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport
        from metriport.commons import Address

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.facility.create(
                name="Care Facility, LLC",
                npi="1234567891",
                address=Address(
                    address_line_1="2261 Market Street",
                    address_line_2="#4818",
                    city="San Francisco",
                    state="CA",
                    zip="94114",
                    country="USA",
                ),
                tin="12-3456789",
                active=True,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/facility",
            method="POST",
            json={
                "name": name,
                "npi": npi,
                "tin": tin,
                "active": active,
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=Address, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Facility,
                    parse_obj_as(
                        type_=Facility,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Facility:
        """
        Get a Facility in Metriport where your patients receive care.

        Parameters
        ----------
        id : str
            The ID assigned to this Facility. This ID will be used
            to uniquely identify this Facility in medical documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Facility

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.facility.get(
                id="018a80c4-292a-7486-a1234-9uiu76yhe234",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/facility/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Facility,
                    parse_obj_as(
                        type_=Facility,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: str,
        npi: str,
        address: Address,
        tin: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Facility:
        """
        Updates a Facility in Metriport where your patients receive care.

        Parameters
        ----------
        id : str
            The ID of the Facility.

        name : str
            The name of your Facility. This is the actual address where a patient will receive care (can be virtual) - for example `Care Facility, LLC`.

        npi : str
            The 10 digit National Provider Identifier (NPI) that will be used to make requests on behalf of the Facility.

        address : Address

        tin : typing.Optional[str]
            The Taxpayer Identification Number (TIN) of the Facility.

        active : typing.Optional[bool]
            Whether or not this Facility is currently active - this is usually `true`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Facility

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport
        from metriport.commons import Address

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.facility.update(
                id="018a80c4-292a-7486-a1234-9uiu76yhe234",
                name="Care Facility, LLC",
                npi="1234567891",
                address=Address(
                    address_line_1="2261 Market Street",
                    address_line_2="#4818",
                    city="San Francisco",
                    state="CA",
                    zip="94114",
                    country="USA",
                ),
                tin="12-3456789",
                active=True,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/facility/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "name": name,
                "npi": npi,
                "tin": tin,
                "active": active,
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=Address, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Facility,
                    parse_obj_as(
                        type_=Facility,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListFacilitiesResponse:
        """
        Lists all of your Facilities.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListFacilitiesResponse
            Array of all of the Facilities created under your Organization.

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.facility.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/facility",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListFacilitiesResponse,
                    parse_obj_as(
                        type_=ListFacilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a Facility. Throws 400 if there are patients associated with the Facility.

        Parameters
        ----------
        id : str
            The ID of the Facility.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.facility.delete(
                id="018a80c4-292a-7486-a1234-9uiu76yhe234",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"medical/v1/facility/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
