# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from .types.document_query import DocumentQuery
from ...core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from .types.list_document_references import ListDocumentReferences
from .types.conversion_type import ConversionType
from .types.document_url import DocumentUrl
from ...fhir.types.document_reference_content import DocumentReferenceContent
from ...fhir.types.identifier import Identifier
from ...fhir.types.document_reference_status import DocumentReferenceStatus
from ...fhir.types.code import Code
from ...fhir.types.codeable_concept import CodeableConcept
from ...fhir.types.reference import Reference
from ...fhir.types.instant import Instant
from ...fhir.types.document_reference_relates_to import DocumentReferenceRelatesTo
from ...fhir.types.document_reference_context import DocumentReferenceContext
from ...fhir.types.id import Id
from ...fhir.types.meta import Meta
from ...fhir.types.uri import Uri
from ...fhir.types.narrative import Narrative
from ...fhir.types.extension import Extension
from .types.upload_document_response import UploadDocumentResponse
from ...core.serialization import convert_and_respect_annotation_metadata
from .types.bulk_get_document_url_query import BulkGetDocumentUrlQuery
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DocumentClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def start_query(
        self,
        *,
        patient_id: str,
        facility_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentQuery:
        """
        Triggers a document query for the specified patient across HIEs.
        When executed, this endpoint triggers an asynchronous document query across HIEs.
        This is a two step process where the documents will first be downloaded from
        the respective HIE and, if they are C-CDA/XML, then converted to FHIR.
        Each process (download, conversion) will contain its own `total` and `status`
        as well as the count for `successful` operations and `errors`.
        When the asynchronous document query finishes, it stores new/updated document
        references for future requests and updates the status of download to `completed`.
        Meanwhile, in the background, files will be converted and the convert count will be
        incremented. Once all documents have been converted it too will be marked as `completed`.
        If there's no document to be converted, the total will be set to zero and
        the status to `completed`.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        facility_id : str
            The ID of the Facility where the patient is receiving care.

        request : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentQuery

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.start_query(
            patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
            facility_id="018a80c4-292a-7486-a1234-9uiu76yhe234",
            request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/document/query",
            method="POST",
            params={
                "patientId": patient_id,
                "facilityId": facility_id,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DocumentQuery,
                    parse_obj_as(
                        type_=DocumentQuery,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_query_status(
        self,
        *,
        patient_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentQuery:
        """
        Returns the document query status for the specified patient.
        Can be used in to check the progress when the final status
        of the document query is taking longer than expected.
        See more on [Start Document Query](/medical-api/api-reference/document/start-document-query).

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentQuery

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.get_query_status(
            patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/document/query",
            method="POST",
            params={
                "patientId": patient_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DocumentQuery,
                    parse_obj_as(
                        type_=DocumentQuery,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(
        self,
        *,
        patient_id: str,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        content: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListDocumentReferences:
        """
        Lists all Documents that can be retrieved for a Patient.
        This endpoint returns the document references available
        at Metriport which are associated with the given Patient.
        To start a new document query, see the [Start Document Query endpoint](/api-reference/medical/document/start-query).

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        date_from : typing.Optional[str]
            The start date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no start date filter will be applied.

        date_to : typing.Optional[str]
            The end date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no end date filter will be applied.

        content : typing.Optional[str]
            Value to search within the document reference and the actual contents of the document (minimum 3 chars).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListDocumentReferences

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.list(
            patient_id="string",
            date_from="string",
            date_to="string",
            content="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/document",
            method="GET",
            params={
                "patientId": patient_id,
                "dateFrom": date_from,
                "dateTo": date_to,
                "content": content,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListDocumentReferences,
                    parse_obj_as(
                        type_=ListDocumentReferences,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_url(
        self,
        *,
        file_name: str,
        conversion_type: typing.Optional[ConversionType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentUrl:
        """
        Gets a downloadable URL for downloading the specified document.
        This endpoint returns a URL which you can use to download
        the specified document and/or convert using the file name
        provided from the [List Documents](/api-reference/medical/document/list) endpoint.

        Parameters
        ----------
        file_name : str
            The file name of the document

        conversion_type : typing.Optional[ConversionType]
            The doc type to convert to. Either `html` or `pdf`.
            This parameter should only be used for converting XML/CDA files.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentUrl
            A json object containing the URL will be returned.

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.get_url(
            file_name="x-ray",
            conversion_type="pdf",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/document/download-url",
            method="GET",
            params={
                "fileName": file_name,
                "conversionType": conversion_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DocumentUrl,
                    parse_obj_as(
                        type_=DocumentUrl,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_document_reference(
        self,
        *,
        patient_id: str,
        content: typing.Sequence[DocumentReferenceContent],
        master_identifier: typing.Optional[Identifier] = OMIT,
        identifier: typing.Optional[typing.Sequence[Identifier]] = OMIT,
        status: typing.Optional[DocumentReferenceStatus] = OMIT,
        doc_status: typing.Optional[Code] = OMIT,
        type: typing.Optional[CodeableConcept] = OMIT,
        category: typing.Optional[typing.Sequence[CodeableConcept]] = OMIT,
        subject: typing.Optional[Reference] = OMIT,
        date: typing.Optional[Instant] = OMIT,
        author: typing.Optional[typing.Sequence[Reference]] = OMIT,
        authenticator: typing.Optional[Reference] = OMIT,
        custodian: typing.Optional[Reference] = OMIT,
        relates_to: typing.Optional[typing.Sequence[DocumentReferenceRelatesTo]] = OMIT,
        description: typing.Optional[str] = OMIT,
        security_label: typing.Optional[typing.Sequence[CodeableConcept]] = OMIT,
        context: typing.Optional[DocumentReferenceContext] = OMIT,
        id: typing.Optional[Id] = OMIT,
        meta: typing.Optional[Meta] = OMIT,
        implicit_rules: typing.Optional[Uri] = OMIT,
        language: typing.Optional[Code] = OMIT,
        text: typing.Optional[Narrative] = OMIT,
        contained: typing.Optional[typing.Any] = OMIT,
        extension: typing.Optional[typing.Sequence[Extension]] = OMIT,
        modifier_extension: typing.Optional[typing.Sequence[Extension]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadDocumentResponse:
        """
        Creates a DocumentReference and returns its ID and a URL to use for a medical document upload to our servers.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        content : typing.Sequence[DocumentReferenceContent]
            The document and format referenced. There may be multiple content element repetitions, each with a different format.

        master_identifier : typing.Optional[Identifier]
            Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.

        identifier : typing.Optional[typing.Sequence[Identifier]]
            Other identifiers associated with the document, including version independent identifiers.

        status : typing.Optional[DocumentReferenceStatus]
            The status of this document reference.

        doc_status : typing.Optional[Code]
            The status of the underlying document.

        type : typing.Optional[CodeableConcept]
            Specifies the particular kind of document referenced (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.

        category : typing.Optional[typing.Sequence[CodeableConcept]]
            A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.

        subject : typing.Optional[Reference]
            Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).

        date : typing.Optional[Instant]
            When the document reference was created.

        author : typing.Optional[typing.Sequence[Reference]]
            Identifies who is responsible for adding the information to the document.

        authenticator : typing.Optional[Reference]
            Which person or organization authenticates that this document is valid.

        custodian : typing.Optional[Reference]
            Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.

        relates_to : typing.Optional[typing.Sequence[DocumentReferenceRelatesTo]]
            Relationships that this document has with other document references that already exist.

        description : typing.Optional[str]
            Human-readable description of the source document.

        security_label : typing.Optional[typing.Sequence[CodeableConcept]]
            A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the "reference" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.

        context : typing.Optional[DocumentReferenceContext]
            The clinical context in which the document was prepared.

        id : typing.Optional[Id]
            The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.

        meta : typing.Optional[Meta]
            The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.

        implicit_rules : typing.Optional[Uri]
            A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.

        language : typing.Optional[Code]
            The base language in which the resource is written.

        text : typing.Optional[Narrative]
            A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.

        contained : typing.Optional[typing.Any]
            These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.

        extension : typing.Optional[typing.Sequence[Extension]]
            May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.

        modifier_extension : typing.Optional[typing.Sequence[Extension]]
            May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadDocumentResponse
            The DocumentReference ID and a URL to be used for file upload.

        Examples
        --------
        from metriport import Metriport
        from metriport.fhir import (
            Attachment,
            CodeableConcept,
            Coding,
            DocumentReferenceContent,
            DocumentReferenceContext,
            Period,
        )

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.create_document_reference(
            patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
            content=[
                DocumentReferenceContent(
                    attachment=Attachment(
                        title="Burn management Hospital Progress note",
                    ),
                )
            ],
            contained=[
                {"resourceType": "ExampleResource", "id": "exampleId1"},
                {"resourceType": "ExampleResource", "id": "exampleId2"},
            ],
            description="Third degree wrist burn treatment",
            type=CodeableConcept(
                text="Burn management Hospital Progress note",
                coding=[
                    Coding(
                        code="100556-0",
                        system="http://loinc.org",
                        display="Burn management Hospital Progress note",
                    )
                ],
            ),
            context=DocumentReferenceContext(
                period=Period(
                    start="2023-10-10T14:14:17Z",
                    end="2023-10-10T15:30:30Z",
                ),
                facility_type=CodeableConcept(
                    text="John Snow Clinic - Acute Care Centre",
                ),
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/document/upload",
            method="POST",
            params={
                "patientId": patient_id,
            },
            json={
                "masterIdentifier": convert_and_respect_annotation_metadata(
                    object_=master_identifier, annotation=Identifier, direction="write"
                ),
                "identifier": convert_and_respect_annotation_metadata(
                    object_=identifier,
                    annotation=typing.Sequence[Identifier],
                    direction="write",
                ),
                "status": status,
                "docStatus": doc_status,
                "type": convert_and_respect_annotation_metadata(
                    object_=type, annotation=CodeableConcept, direction="write"
                ),
                "category": convert_and_respect_annotation_metadata(
                    object_=category,
                    annotation=typing.Sequence[CodeableConcept],
                    direction="write",
                ),
                "subject": convert_and_respect_annotation_metadata(
                    object_=subject, annotation=Reference, direction="write"
                ),
                "date": date,
                "author": convert_and_respect_annotation_metadata(
                    object_=author,
                    annotation=typing.Sequence[Reference],
                    direction="write",
                ),
                "authenticator": convert_and_respect_annotation_metadata(
                    object_=authenticator, annotation=Reference, direction="write"
                ),
                "custodian": convert_and_respect_annotation_metadata(
                    object_=custodian, annotation=Reference, direction="write"
                ),
                "relatesTo": convert_and_respect_annotation_metadata(
                    object_=relates_to,
                    annotation=typing.Sequence[DocumentReferenceRelatesTo],
                    direction="write",
                ),
                "description": description,
                "securityLabel": convert_and_respect_annotation_metadata(
                    object_=security_label,
                    annotation=typing.Sequence[CodeableConcept],
                    direction="write",
                ),
                "content": convert_and_respect_annotation_metadata(
                    object_=content,
                    annotation=typing.Sequence[DocumentReferenceContent],
                    direction="write",
                ),
                "context": convert_and_respect_annotation_metadata(
                    object_=context,
                    annotation=DocumentReferenceContext,
                    direction="write",
                ),
                "id": id,
                "meta": convert_and_respect_annotation_metadata(
                    object_=meta, annotation=Meta, direction="write"
                ),
                "implicitRules": implicit_rules,
                "language": language,
                "text": convert_and_respect_annotation_metadata(
                    object_=text, annotation=Narrative, direction="write"
                ),
                "contained": contained,
                "extension": convert_and_respect_annotation_metadata(
                    object_=extension,
                    annotation=typing.Sequence[Extension],
                    direction="write",
                ),
                "modifierExtension": convert_and_respect_annotation_metadata(
                    object_=modifier_extension,
                    annotation=typing.Sequence[Extension],
                    direction="write",
                ),
                "resourceType": "DocumentReference",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UploadDocumentResponse,
                    parse_obj_as(
                        type_=UploadDocumentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def start_bulk_get_document_url(
        self,
        *,
        patient_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkGetDocumentUrlQuery:
        """
        Triggers a process to generate a list of download URLs for all of the patient's documents.
        The status of the process is returned in the response. Initially, it will be `processing`,
        and when the process is finished, the status will be updated to `completed` or `failed`.
        If you trigger this endpoint again while the process is still running, you will get a response
        that reflects the current progress.

        Parameters
        ----------
        patient_id : str
            The ID of the patient for which to initiate the bulk URL generation.

        request : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkGetDocumentUrlQuery
            The status of the URL generation process and the request ID.

        Examples
        --------
        from metriport import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.start_bulk_get_document_url(
            patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
            request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "medical/v1/document/download-url/bulk",
            method="POST",
            params={
                "patientId": patient_id,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    BulkGetDocumentUrlQuery,
                    parse_obj_as(
                        type_=BulkGetDocumentUrlQuery,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDocumentClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def start_query(
        self,
        *,
        patient_id: str,
        facility_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentQuery:
        """
        Triggers a document query for the specified patient across HIEs.
        When executed, this endpoint triggers an asynchronous document query across HIEs.
        This is a two step process where the documents will first be downloaded from
        the respective HIE and, if they are C-CDA/XML, then converted to FHIR.
        Each process (download, conversion) will contain its own `total` and `status`
        as well as the count for `successful` operations and `errors`.
        When the asynchronous document query finishes, it stores new/updated document
        references for future requests and updates the status of download to `completed`.
        Meanwhile, in the background, files will be converted and the convert count will be
        incremented. Once all documents have been converted it too will be marked as `completed`.
        If there's no document to be converted, the total will be set to zero and
        the status to `completed`.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        facility_id : str
            The ID of the Facility where the patient is receiving care.

        request : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentQuery

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.document.start_query(
                patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
                facility_id="018a80c4-292a-7486-a1234-9uiu76yhe234",
                request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/document/query",
            method="POST",
            params={
                "patientId": patient_id,
                "facilityId": facility_id,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DocumentQuery,
                    parse_obj_as(
                        type_=DocumentQuery,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_query_status(
        self,
        *,
        patient_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentQuery:
        """
        Returns the document query status for the specified patient.
        Can be used in to check the progress when the final status
        of the document query is taking longer than expected.
        See more on [Start Document Query](/medical-api/api-reference/document/start-document-query).

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentQuery

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.document.get_query_status(
                patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/document/query",
            method="POST",
            params={
                "patientId": patient_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DocumentQuery,
                    parse_obj_as(
                        type_=DocumentQuery,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(
        self,
        *,
        patient_id: str,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        content: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListDocumentReferences:
        """
        Lists all Documents that can be retrieved for a Patient.
        This endpoint returns the document references available
        at Metriport which are associated with the given Patient.
        To start a new document query, see the [Start Document Query endpoint](/api-reference/medical/document/start-query).

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        date_from : typing.Optional[str]
            The start date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no start date filter will be applied.

        date_to : typing.Optional[str]
            The end date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no end date filter will be applied.

        content : typing.Optional[str]
            Value to search within the document reference and the actual contents of the document (minimum 3 chars).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListDocumentReferences

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.document.list(
                patient_id="string",
                date_from="string",
                date_to="string",
                content="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/document",
            method="GET",
            params={
                "patientId": patient_id,
                "dateFrom": date_from,
                "dateTo": date_to,
                "content": content,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListDocumentReferences,
                    parse_obj_as(
                        type_=ListDocumentReferences,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_url(
        self,
        *,
        file_name: str,
        conversion_type: typing.Optional[ConversionType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentUrl:
        """
        Gets a downloadable URL for downloading the specified document.
        This endpoint returns a URL which you can use to download
        the specified document and/or convert using the file name
        provided from the [List Documents](/api-reference/medical/document/list) endpoint.

        Parameters
        ----------
        file_name : str
            The file name of the document

        conversion_type : typing.Optional[ConversionType]
            The doc type to convert to. Either `html` or `pdf`.
            This parameter should only be used for converting XML/CDA files.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentUrl
            A json object containing the URL will be returned.

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.document.get_url(
                file_name="x-ray",
                conversion_type="pdf",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/document/download-url",
            method="GET",
            params={
                "fileName": file_name,
                "conversionType": conversion_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DocumentUrl,
                    parse_obj_as(
                        type_=DocumentUrl,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_document_reference(
        self,
        *,
        patient_id: str,
        content: typing.Sequence[DocumentReferenceContent],
        master_identifier: typing.Optional[Identifier] = OMIT,
        identifier: typing.Optional[typing.Sequence[Identifier]] = OMIT,
        status: typing.Optional[DocumentReferenceStatus] = OMIT,
        doc_status: typing.Optional[Code] = OMIT,
        type: typing.Optional[CodeableConcept] = OMIT,
        category: typing.Optional[typing.Sequence[CodeableConcept]] = OMIT,
        subject: typing.Optional[Reference] = OMIT,
        date: typing.Optional[Instant] = OMIT,
        author: typing.Optional[typing.Sequence[Reference]] = OMIT,
        authenticator: typing.Optional[Reference] = OMIT,
        custodian: typing.Optional[Reference] = OMIT,
        relates_to: typing.Optional[typing.Sequence[DocumentReferenceRelatesTo]] = OMIT,
        description: typing.Optional[str] = OMIT,
        security_label: typing.Optional[typing.Sequence[CodeableConcept]] = OMIT,
        context: typing.Optional[DocumentReferenceContext] = OMIT,
        id: typing.Optional[Id] = OMIT,
        meta: typing.Optional[Meta] = OMIT,
        implicit_rules: typing.Optional[Uri] = OMIT,
        language: typing.Optional[Code] = OMIT,
        text: typing.Optional[Narrative] = OMIT,
        contained: typing.Optional[typing.Any] = OMIT,
        extension: typing.Optional[typing.Sequence[Extension]] = OMIT,
        modifier_extension: typing.Optional[typing.Sequence[Extension]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadDocumentResponse:
        """
        Creates a DocumentReference and returns its ID and a URL to use for a medical document upload to our servers.

        Parameters
        ----------
        patient_id : str
            The ID of the Patient for which to list available Documents.

        content : typing.Sequence[DocumentReferenceContent]
            The document and format referenced. There may be multiple content element repetitions, each with a different format.

        master_identifier : typing.Optional[Identifier]
            Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.

        identifier : typing.Optional[typing.Sequence[Identifier]]
            Other identifiers associated with the document, including version independent identifiers.

        status : typing.Optional[DocumentReferenceStatus]
            The status of this document reference.

        doc_status : typing.Optional[Code]
            The status of the underlying document.

        type : typing.Optional[CodeableConcept]
            Specifies the particular kind of document referenced (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.

        category : typing.Optional[typing.Sequence[CodeableConcept]]
            A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.

        subject : typing.Optional[Reference]
            Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).

        date : typing.Optional[Instant]
            When the document reference was created.

        author : typing.Optional[typing.Sequence[Reference]]
            Identifies who is responsible for adding the information to the document.

        authenticator : typing.Optional[Reference]
            Which person or organization authenticates that this document is valid.

        custodian : typing.Optional[Reference]
            Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.

        relates_to : typing.Optional[typing.Sequence[DocumentReferenceRelatesTo]]
            Relationships that this document has with other document references that already exist.

        description : typing.Optional[str]
            Human-readable description of the source document.

        security_label : typing.Optional[typing.Sequence[CodeableConcept]]
            A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the "reference" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.

        context : typing.Optional[DocumentReferenceContext]
            The clinical context in which the document was prepared.

        id : typing.Optional[Id]
            The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.

        meta : typing.Optional[Meta]
            The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.

        implicit_rules : typing.Optional[Uri]
            A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.

        language : typing.Optional[Code]
            The base language in which the resource is written.

        text : typing.Optional[Narrative]
            A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.

        contained : typing.Optional[typing.Any]
            These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.

        extension : typing.Optional[typing.Sequence[Extension]]
            May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.

        modifier_extension : typing.Optional[typing.Sequence[Extension]]
            May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadDocumentResponse
            The DocumentReference ID and a URL to be used for file upload.

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport
        from metriport.fhir import (
            Attachment,
            CodeableConcept,
            Coding,
            DocumentReferenceContent,
            DocumentReferenceContext,
            Period,
        )

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.document.create_document_reference(
                patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
                content=[
                    DocumentReferenceContent(
                        attachment=Attachment(
                            title="Burn management Hospital Progress note",
                        ),
                    )
                ],
                contained=[
                    {"resourceType": "ExampleResource", "id": "exampleId1"},
                    {"resourceType": "ExampleResource", "id": "exampleId2"},
                ],
                description="Third degree wrist burn treatment",
                type=CodeableConcept(
                    text="Burn management Hospital Progress note",
                    coding=[
                        Coding(
                            code="100556-0",
                            system="http://loinc.org",
                            display="Burn management Hospital Progress note",
                        )
                    ],
                ),
                context=DocumentReferenceContext(
                    period=Period(
                        start="2023-10-10T14:14:17Z",
                        end="2023-10-10T15:30:30Z",
                    ),
                    facility_type=CodeableConcept(
                        text="John Snow Clinic - Acute Care Centre",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/document/upload",
            method="POST",
            params={
                "patientId": patient_id,
            },
            json={
                "masterIdentifier": convert_and_respect_annotation_metadata(
                    object_=master_identifier, annotation=Identifier, direction="write"
                ),
                "identifier": convert_and_respect_annotation_metadata(
                    object_=identifier,
                    annotation=typing.Sequence[Identifier],
                    direction="write",
                ),
                "status": status,
                "docStatus": doc_status,
                "type": convert_and_respect_annotation_metadata(
                    object_=type, annotation=CodeableConcept, direction="write"
                ),
                "category": convert_and_respect_annotation_metadata(
                    object_=category,
                    annotation=typing.Sequence[CodeableConcept],
                    direction="write",
                ),
                "subject": convert_and_respect_annotation_metadata(
                    object_=subject, annotation=Reference, direction="write"
                ),
                "date": date,
                "author": convert_and_respect_annotation_metadata(
                    object_=author,
                    annotation=typing.Sequence[Reference],
                    direction="write",
                ),
                "authenticator": convert_and_respect_annotation_metadata(
                    object_=authenticator, annotation=Reference, direction="write"
                ),
                "custodian": convert_and_respect_annotation_metadata(
                    object_=custodian, annotation=Reference, direction="write"
                ),
                "relatesTo": convert_and_respect_annotation_metadata(
                    object_=relates_to,
                    annotation=typing.Sequence[DocumentReferenceRelatesTo],
                    direction="write",
                ),
                "description": description,
                "securityLabel": convert_and_respect_annotation_metadata(
                    object_=security_label,
                    annotation=typing.Sequence[CodeableConcept],
                    direction="write",
                ),
                "content": convert_and_respect_annotation_metadata(
                    object_=content,
                    annotation=typing.Sequence[DocumentReferenceContent],
                    direction="write",
                ),
                "context": convert_and_respect_annotation_metadata(
                    object_=context,
                    annotation=DocumentReferenceContext,
                    direction="write",
                ),
                "id": id,
                "meta": convert_and_respect_annotation_metadata(
                    object_=meta, annotation=Meta, direction="write"
                ),
                "implicitRules": implicit_rules,
                "language": language,
                "text": convert_and_respect_annotation_metadata(
                    object_=text, annotation=Narrative, direction="write"
                ),
                "contained": contained,
                "extension": convert_and_respect_annotation_metadata(
                    object_=extension,
                    annotation=typing.Sequence[Extension],
                    direction="write",
                ),
                "modifierExtension": convert_and_respect_annotation_metadata(
                    object_=modifier_extension,
                    annotation=typing.Sequence[Extension],
                    direction="write",
                ),
                "resourceType": "DocumentReference",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UploadDocumentResponse,
                    parse_obj_as(
                        type_=UploadDocumentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def start_bulk_get_document_url(
        self,
        *,
        patient_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkGetDocumentUrlQuery:
        """
        Triggers a process to generate a list of download URLs for all of the patient's documents.
        The status of the process is returned in the response. Initially, it will be `processing`,
        and when the process is finished, the status will be updated to `completed` or `failed`.
        If you trigger this endpoint again while the process is still running, you will get a response
        that reflects the current progress.

        Parameters
        ----------
        patient_id : str
            The ID of the patient for which to initiate the bulk URL generation.

        request : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkGetDocumentUrlQuery
            The status of the URL generation process and the request ID.

        Examples
        --------
        import asyncio

        from metriport import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.medical.document.start_bulk_get_document_url(
                patient_id="018a80c4-292a-7486-a1234-76yuhe23yu14",
                request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "medical/v1/document/download-url/bulk",
            method="POST",
            params={
                "patientId": patient_id,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    BulkGetDocumentUrlQuery,
                    parse_obj_as(
                        type_=BulkGetDocumentUrlQuery,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
