# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
from .document.client import DocumentClient
from .facility.client import FacilityClient
from .fhir.client import FhirClient
from .patient.client import PatientClient
from ..core.client_wrapper import AsyncClientWrapper
from .document.client import AsyncDocumentClient
from .facility.client import AsyncFacilityClient
from .fhir.client import AsyncFhirClient
from .patient.client import AsyncPatientClient


class MedicalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.document = DocumentClient(client_wrapper=self._client_wrapper)
        self.facility = FacilityClient(client_wrapper=self._client_wrapper)
        self.fhir = FhirClient(client_wrapper=self._client_wrapper)
        self.patient = PatientClient(client_wrapper=self._client_wrapper)


class AsyncMedicalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.document = AsyncDocumentClient(client_wrapper=self._client_wrapper)
        self.facility = AsyncFacilityClient(client_wrapper=self._client_wrapper)
        self.fhir = AsyncFhirClient(client_wrapper=self._client_wrapper)
        self.patient = AsyncPatientClient(client_wrapper=self._client_wrapper)
