# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
import datetime as dt
from .verification_result_primary_source import VerificationResultPrimarySource
from .verification_result_attestation import VerificationResultAttestation
from .verification_result_validator import VerificationResultValidator
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class VerificationResult(BaseResource):
    """
    Describes validation requirements, source(s), status and dates for one or more elements.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["VerificationResult"], FieldMetadata(alias="resourceType")
    ] = "VerificationResult"
    target: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    A resource that was validated.
    """

    target_location: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="targetLocation")
    ] = pydantic.Field(default=None)
    """
    The fhirpath location(s) within the resource that was validated.
    """

    need: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The frequency with which the target must be validated (none; initial; periodic).
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The validation status of the target (attested; validated; in process; requires revalidation; validation failed; revalidation failed).
    """

    status_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="statusDate")
    ] = pydantic.Field(default=None)
    """
    When the validation status was updated.
    """

    validation_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="validationType")
    ] = pydantic.Field(default=None)
    """
    What the target is validated against (nothing; primary source; multiple sources).
    """

    validation_process: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="validationProcess"),
    ] = pydantic.Field(default=None)
    """
    The primary process by which the target is validated (edit check; value set; primary source; multiple sources; standalone; in context).
    """

    frequency: typing.Optional[Timing] = pydantic.Field(default=None)
    """
    Frequency of revalidation.
    """

    last_performed: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="lastPerformed")
    ] = pydantic.Field(default=None)
    """
    The date/time validation was last completed (including failed validations).
    """

    next_scheduled: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="nextScheduled")
    ] = pydantic.Field(default=None)
    """
    The date when target is next validated, if appropriate.
    """

    failure_action: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="failureAction")
    ] = pydantic.Field(default=None)
    """
    The result if validation fails (fatal; warning; record only; none).
    """

    primary_source: typing_extensions.Annotated[
        typing.Optional[typing.List[VerificationResultPrimarySource]],
        FieldMetadata(alias="primarySource"),
    ] = pydantic.Field(default=None)
    """
    Information about the primary source(s) involved in validation.
    """

    attestation: typing.Optional[VerificationResultAttestation] = pydantic.Field(
        default=None
    )
    """
    Information about the entity attesting to information.
    """

    validator: typing.Optional[typing.List[VerificationResultValidator]] = (
        pydantic.Field(default=None)
    )
    """
    Information about the entity validating information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
