# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .id import Id
import pydantic
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .code import Code
from .decimal import Decimal
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class UserConfigurationOption(UniversalBaseModel):
    """
    User options that control the display of the application.
    """

    id: Id = pydantic.Field()
    """
    The unique identifier of the option.
    """

    value_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="valueBoolean")
    ] = pydantic.Field(default=None)
    """
    Value of option - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_code: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="valueCode")
    ] = pydantic.Field(default=None)
    """
    Value of option - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_decimal: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="valueDecimal")
    ] = pydantic.Field(default=None)
    """
    Value of option - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_integer: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="valueInteger")
    ] = pydantic.Field(default=None)
    """
    Value of option - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueString")
    ] = pydantic.Field(default=None)
    """
    Value of option - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
