# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .trigger_definition_type import TriggerDefinitionType
import typing_extensions
from ...core.serialization import FieldMetadata
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class TriggerDefinition(UniversalBaseModel):
    """
    A description of a triggering event. Triggering events can be named events, data events, or periodic, as determined by the type element.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    type: typing.Optional[TriggerDefinitionType] = pydantic.Field(default=None)
    """
    The type of triggering event.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A formal name for the event. This may be an absolute URI that identifies the event formally (e.g. from a trigger registry), or a simple relative URI that identifies the event in a local context.
    """

    timing_timing: typing_extensions.Annotated[
        typing.Optional["Timing"], FieldMetadata(alias="timingTiming")
    ] = pydantic.Field(default=None)
    """
    The timing of the event (if this is a periodic trigger).
    """

    timing_reference: typing_extensions.Annotated[
        typing.Optional["Reference"], FieldMetadata(alias="timingReference")
    ] = pydantic.Field(default=None)
    """
    The timing of the event (if this is a periodic trigger).
    """

    timing_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="timingDate")
    ] = pydantic.Field(default=None)
    """
    The timing of the event (if this is a periodic trigger).
    """

    timing_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="timingDateTime")
    ] = pydantic.Field(default=None)
    """
    The timing of the event (if this is a periodic trigger).
    """

    data: typing.Optional[typing.List["DataRequirement"]] = pydantic.Field(default=None)
    """
    The triggering data of the event (if this is a data trigger). If more than one data is requirement is specified, then all the data requirements must be true.
    """

    condition: typing.Optional["Expression"] = pydantic.Field(default=None)
    """
    A boolean-valued expression that is evaluated in the context of the container of the trigger definition and returns whether or not the trigger fires.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement import DataRequirement  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .meta import Meta  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .sampled_data import SampledData  # noqa: E402
from .signature import Signature  # noqa: E402
from .timing import Timing  # noqa: E402
from .timing_repeat import TimingRepeat  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(TriggerDefinition)
