# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .positive_int import PositiveInt
from .decimal import Decimal
from .timing_repeat_duration_unit import TimingRepeatDurationUnit
from .timing_repeat_period_unit import TimingRepeatPeriodUnit
from .code import Code
from .time import Time
from .timing_repeat_when_item import TimingRepeatWhenItem
from .unsigned_int import UnsignedInt
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class TimingRepeat(UniversalBaseModel):
    """
    Specifies an event that may occur multiple times. Timing schedules are used to record when things are planned, expected or requested to occur. The most common usage is in dosage instructions for medications. They are also used when planning care of various kinds, and may be used for reporting the schedule to which past regular activities were carried out.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List["Extension"]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    bounds_duration: typing_extensions.Annotated[
        typing.Optional["Duration"], FieldMetadata(alias="boundsDuration")
    ] = pydantic.Field(default=None)
    """
    Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.
    """

    bounds_range: typing_extensions.Annotated[
        typing.Optional["Range"], FieldMetadata(alias="boundsRange")
    ] = pydantic.Field(default=None)
    """
    Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.
    """

    bounds_period: typing_extensions.Annotated[
        typing.Optional["Period"], FieldMetadata(alias="boundsPeriod")
    ] = pydantic.Field(default=None)
    """
    Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.
    """

    count: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    A total count of the desired number of repetitions across the duration of the entire timing specification. If countMax is present, this element indicates the lower bound of the allowed range of count values.
    """

    count_max: typing_extensions.Annotated[
        typing.Optional[PositiveInt], FieldMetadata(alias="countMax")
    ] = pydantic.Field(default=None)
    """
    If present, indicates that the count is a range - so to perform the action between [count] and [countMax] times.
    """

    duration: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    How long this thing happens for when it happens. If durationMax is present, this element indicates the lower bound of the allowed range of the duration.
    """

    duration_max: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="durationMax")
    ] = pydantic.Field(default=None)
    """
    If present, indicates that the duration is a range - so to perform the action between [duration] and [durationMax] time length.
    """

    duration_unit: typing_extensions.Annotated[
        typing.Optional[TimingRepeatDurationUnit], FieldMetadata(alias="durationUnit")
    ] = pydantic.Field(default=None)
    """
    The units of time for the duration, in UCUM units.
    """

    frequency: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    The number of times to repeat the action within the specified period. If frequencyMax is present, this element indicates the lower bound of the allowed range of the frequency.
    """

    frequency_max: typing_extensions.Annotated[
        typing.Optional[PositiveInt], FieldMetadata(alias="frequencyMax")
    ] = pydantic.Field(default=None)
    """
    If present, indicates that the frequency is a range - so to repeat between [frequency] and [frequencyMax] times within the period or period range.
    """

    period: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    Indicates the duration of time over which repetitions are to occur; e.g. to express "3 times per day", 3 would be the frequency and "1 day" would be the period. If periodMax is present, this element indicates the lower bound of the allowed range of the period length.
    """

    period_max: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="periodMax")
    ] = pydantic.Field(default=None)
    """
    If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as "do this once every 3-5 days.
    """

    period_unit: typing_extensions.Annotated[
        typing.Optional[TimingRepeatPeriodUnit], FieldMetadata(alias="periodUnit")
    ] = pydantic.Field(default=None)
    """
    The units of time for the period in UCUM units.
    """

    day_of_week: typing_extensions.Annotated[
        typing.Optional[typing.List[Code]], FieldMetadata(alias="dayOfWeek")
    ] = pydantic.Field(default=None)
    """
    If one or more days of week is provided, then the action happens only on the specified day(s).
    """

    time_of_day: typing_extensions.Annotated[
        typing.Optional[typing.List[Time]], FieldMetadata(alias="timeOfDay")
    ] = pydantic.Field(default=None)
    """
    Specified time of day for action to take place.
    """

    when: typing.Optional[typing.List[TimingRepeatWhenItem]] = pydantic.Field(
        default=None
    )
    """
    An approximate time period during the day, potentially linked to an event of daily living that indicates when the action should occur.
    """

    offset: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    The number of minutes from the event. If the event code does not indicate whether the minutes is before or after the event, then the offset is assumed to be after the event.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement import DataRequirement  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .meta import Meta  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .sampled_data import SampledData  # noqa: E402
from .signature import Signature  # noqa: E402
from .timing import Timing  # noqa: E402
from .trigger_definition import TriggerDefinition  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(TimingRepeat)
