# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .test_script_operation_method import TestScriptOperationMethod
from .test_script_request_header import TestScriptRequestHeader
from .id import Id
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TestScriptOperation(UniversalBaseModel):
    """
    A structured set of tests against a FHIR server or client implementation to determine compliance against the FHIR specification.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    type: typing.Optional[Coding] = pydantic.Field(default=None)
    """
    Server interaction or operation type.
    """

    resource: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The type of the resource. See http://build.fhir.org/resourcelist.html.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The label would be used for tracking/logging purposes by test engines.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description would be used by test engines for tracking and reporting purposes.
    """

    accept: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The mime-type to use for RESTful operation in the 'Accept' header.
    """

    content_type: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="contentType")
    ] = pydantic.Field(default=None)
    """
    The mime-type to use for RESTful operation in the 'Content-Type' header.
    """

    destination: typing.Optional[int] = pydantic.Field(default=None)
    """
    The server where the request message is destined for. Must be one of the server numbers listed in TestScript.destination section.
    """

    encode_request_url: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="encodeRequestUrl")
    ] = pydantic.Field(default=None)
    """
    Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.
    """

    method: typing.Optional[TestScriptOperationMethod] = pydantic.Field(default=None)
    """
    The HTTP method the test engine MUST use for this operation regardless of any other operation details.
    """

    origin: typing.Optional[int] = pydantic.Field(default=None)
    """
    The server where the request message originates from. Must be one of the server numbers listed in TestScript.origin section.
    """

    params: typing.Optional[str] = pydantic.Field(default=None)
    """
    Path plus parameters after [type]. Used to set parts of the request URL explicitly.
    """

    request_header: typing_extensions.Annotated[
        typing.Optional[typing.List[TestScriptRequestHeader]],
        FieldMetadata(alias="requestHeader"),
    ] = pydantic.Field(default=None)
    """
    Header elements would be used to set HTTP headers.
    """

    request_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="requestId")
    ] = pydantic.Field(default=None)
    """
    The fixture id (maybe new) to map to the request.
    """

    response_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="responseId")
    ] = pydantic.Field(default=None)
    """
    The fixture id (maybe new) to map to the response.
    """

    source_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="sourceId")
    ] = pydantic.Field(default=None)
    """
    The id of the fixture used as the body of a PUT or POST request.
    """

    target_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="targetId")
    ] = pydantic.Field(default=None)
    """
    Id of fixture used for extracting the [id], [type], and [vid] for GET requests.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Complete request URL.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
