# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .test_script_assert_direction import TestScriptAssertDirection
from .code import Code
from .test_script_assert_operator import TestScriptAssertOperator
from .test_script_assert_request_method import TestScriptAssertRequestMethod
from .test_script_assert_response import TestScriptAssertResponse
from .id import Id
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TestScriptAssert(UniversalBaseModel):
    """
    A structured set of tests against a FHIR server or client implementation to determine compliance against the FHIR specification.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The label would be used for tracking/logging purposes by test engines.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description would be used by test engines for tracking and reporting purposes.
    """

    direction: typing.Optional[TestScriptAssertDirection] = pydantic.Field(default=None)
    """
    The direction to use for the assertion.
    """

    compare_to_source_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="compareToSourceId")
    ] = pydantic.Field(default=None)
    """
    Id of the source fixture used as the contents to be evaluated by either the "source/expression" or "sourceId/path" definition.
    """

    compare_to_source_expression: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="compareToSourceExpression")
    ] = pydantic.Field(default=None)
    """
    The FHIRPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.
    """

    compare_to_source_path: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="compareToSourcePath")
    ] = pydantic.Field(default=None)
    """
    XPath or JSONPath expression to evaluate against the source fixture. When compareToSourceId is defined, either compareToSourceExpression or compareToSourcePath must be defined, but not both.
    """

    content_type: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="contentType")
    ] = pydantic.Field(default=None)
    """
    The mime-type contents to compare against the request or response message 'Content-Type' header.
    """

    expression: typing.Optional[str] = pydantic.Field(default=None)
    """
    The FHIRPath expression to be evaluated against the request or response message contents - HTTP headers and payload.
    """

    header_field: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="headerField")
    ] = pydantic.Field(default=None)
    """
    The HTTP header field name e.g. 'Location'.
    """

    minimum_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="minimumId")
    ] = pydantic.Field(default=None)
    """
    The ID of a fixture. Asserts that the response contains at a minimum the fixture specified by minimumId.
    """

    navigation_links: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="navigationLinks")
    ] = pydantic.Field(default=None)
    """
    Whether or not the test execution performs validation on the bundle navigation links.
    """

    operator: typing.Optional[TestScriptAssertOperator] = pydantic.Field(default=None)
    """
    The operator type defines the conditional behavior of the assert. If not defined, the default is equals.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.
    """

    request_method: typing_extensions.Annotated[
        typing.Optional[TestScriptAssertRequestMethod],
        FieldMetadata(alias="requestMethod"),
    ] = pydantic.Field(default=None)
    """
    The request method or HTTP operation code to compare against that used by the client system under test.
    """

    request_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="requestURL")
    ] = pydantic.Field(default=None)
    """
    The value to use in a comparison against the request URL path string.
    """

    resource: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The type of the resource. See http://build.fhir.org/resourcelist.html.
    """

    response: typing.Optional[TestScriptAssertResponse] = pydantic.Field(default=None)
    """
    okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.
    """

    response_code: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="responseCode")
    ] = pydantic.Field(default=None)
    """
    The value of the HTTP response code to be tested.
    """

    source_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="sourceId")
    ] = pydantic.Field(default=None)
    """
    Fixture to evaluate the XPath/JSONPath expression or the headerField against.
    """

    validate_profile_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="validateProfileId")
    ] = pydantic.Field(default=None)
    """
    The ID of the Profile to validate against.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The value to compare to.
    """

    warning_only: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="warningOnly")
    ] = pydantic.Field(default=None)
    """
    Whether or not the test execution will produce a warning only on error for this assert.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
