# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .test_report_status import TestReportStatus
from .test_report_result import TestReportResult
from .decimal import Decimal
from .date_time import DateTime
from .test_report_participant import TestReportParticipant
from .test_report_setup import TestReportSetup
from .test_report_test import TestReportTest
from .test_report_teardown import TestReportTeardown
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TestReport(BaseResource):
    """
    A summary of information based on the results of executing a TestScript.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["TestReport"], FieldMetadata(alias="resourceType")
    ] = "TestReport"
    identifier: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    Identifier for the TestScript assigned for external purposes outside the context of FHIR.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A free text natural language name identifying the executed TestScript.
    """

    status: typing.Optional[TestReportStatus] = pydantic.Field(default=None)
    """
    The current state of this test report.
    """

    test_script: typing_extensions.Annotated[
        Reference, FieldMetadata(alias="testScript")
    ] = pydantic.Field()
    """
    Ideally this is an absolute URL that is used to identify the version-specific TestScript that was executed, matching the `TestScript.url`.
    """

    result: typing.Optional[TestReportResult] = pydantic.Field(default=None)
    """
    The overall result from the execution of the TestScript.
    """

    score: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    The final score (percentage of tests passed) resulting from the execution of the TestScript.
    """

    tester: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the tester producing this report (Organization or individual).
    """

    issued: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    When the TestScript was executed and this TestReport was generated.
    """

    participant: typing.Optional[typing.List[TestReportParticipant]] = pydantic.Field(
        default=None
    )
    """
    A participant in the test execution, either the execution engine, a client, or a server.
    """

    setup: typing.Optional[TestReportSetup] = pydantic.Field(default=None)
    """
    The results of the series of required setup operations before the tests were executed.
    """

    test: typing.Optional[typing.List[TestReportTest]] = pydantic.Field(default=None)
    """
    A test executed from the test script.
    """

    teardown: typing.Optional[TestReportTeardown] = pydantic.Field(default=None)
    """
    The results of the series of operations required to clean up after all the tests were executed (successfully or otherwise).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
