# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .task_status import TaskStatus
from .task_intent import TaskIntent
from .code import Code
from .date_time import DateTime
from .task_restriction import TaskRestriction
from .task_input import TaskInput
from .task_output import TaskOutput
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Task(BaseResource):
    """
    A task to be performed.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Task"], FieldMetadata(alias="resourceType")
    ] = "Task"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    The business identifier for this task.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[Canonical], FieldMetadata(alias="instantiatesCanonical")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a _FHIR_-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an _externally_ maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Task.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    BasedOn refers to a higher-level authorization that triggered the creation of the task. It references a "request" resource such as a ServiceRequest, MedicationRequest, ServiceRequest, CarePlan, etc. which is distinct from the "request" resource the task is seeking to fulfill. This latter resource is referenced by FocusOn. For example, based on a ServiceRequest (= BasedOn), a task is created to fulfill a procedureRequest ( = FocusOn ) to collect a specimen from a patient.
    """

    group_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="groupIdentifier")
    ] = pydantic.Field(default=None)
    """
    An identifier that links together multiple tasks and other requests that were created in the same context.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    Task that this particular task is part of.
    """

    status: typing.Optional[TaskStatus] = pydantic.Field(default=None)
    """
    The current status of the task.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    An explanation as to why this task is held, failed, was refused, etc.
    """

    business_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="businessStatus")
    ] = pydantic.Field(default=None)
    """
    Contains business-specific nuances of the business state.
    """

    intent: typing.Optional[TaskIntent] = pydantic.Field(default=None)
    """
    Indicates the "level" of actionability associated with the Task, i.e. i+R[9]Cs this a proposed task, a planned task, an actionable task, etc.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the Task should be addressed with respect to other requests.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A name or code (or both) briefly describing what the task involves.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A free-text description of what is to be performed.
    """

    focus: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The request being actioned or the resource being manipulated by this task.
    """

    for_: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="for")
    ] = pydantic.Field(default=None)
    """
    The entity who benefits from the performance of the service specified in the task (e.g., the patient).
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The healthcare event (e.g. a patient and healthcare provider interaction) during which this task was created.
    """

    execution_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="executionPeriod")
    ] = pydantic.Field(default=None)
    """
    Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    The date and time this task was created.
    """

    last_modified: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="lastModified")
    ] = pydantic.Field(default=None)
    """
    The date and time of last modification to this task.
    """

    requester: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The creator of the task.
    """

    performer_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="performerType"),
    ] = pydantic.Field(default=None)
    """
    The kind of participant that should perform the task.
    """

    owner: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual organization or Device currently responsible for task execution.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Principal physical location where the this task is performed.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    A description or code indicating why this task needs to be performed.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    A resource reference indicating why this task needs to be performed.
    """

    insurance: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be relevant to the Task.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Free-text information captured about the task as it progresses.
    """

    relevant_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="relevantHistory")
    ] = pydantic.Field(default=None)
    """
    Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.
    """

    restriction: typing.Optional[TaskRestriction] = pydantic.Field(default=None)
    """
    If the Task.focus is a request resource and the task is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.
    """

    input: typing.Optional[typing.List[TaskInput]] = pydantic.Field(default=None)
    """
    Additional information that may be needed in the execution of the task.
    """

    output: typing.Optional[typing.List[TaskOutput]] = pydantic.Field(default=None)
    """
    Outputs produced by the Task.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
