# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .supply_request_status import SupplyRequestStatus
from .code import Code
from .supply_request_parameter import SupplyRequestParameter
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SupplyRequest(BaseResource):
    """
    A record of a request for a medication, substance or device used in the healthcare setting.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["SupplyRequest"], FieldMetadata(alias="resourceType")
    ] = "SupplyRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this SupplyRequest by the author and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.
    """

    status: typing.Optional[SupplyRequestStatus] = pydantic.Field(default=None)
    """
    Status of the supply request.
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Category of supply, e.g. central, non-stock, etc. This is used to support work flows associated with the supply process.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly this SupplyRequest should be addressed with respect to other requests.
    """

    item_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="itemCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.
    """

    item_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="itemReference")
    ] = pydantic.Field(default=None)
    """
    The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.
    """

    quantity: Quantity = pydantic.Field()
    """
    The amount that is being ordered of the indicated item.
    """

    parameter: typing.Optional[typing.List[SupplyRequestParameter]] = pydantic.Field(
        default=None
    )
    """
    Specific parameters for the ordered item. For example, the size of the indicated item.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    When the request should be fulfilled.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    When the request should be fulfilled.
    """

    occurrence_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="occurrenceTiming")
    ] = pydantic.Field(default=None)
    """
    When the request should be fulfilled.
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    When the request was made.
    """

    requester: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The device, practitioner, etc. who initiated the request.
    """

    supplier: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Who is intended to fulfill the request.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    The reason why the supply item was requested.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    The reason why the supply item was requested.
    """

    deliver_from: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="deliverFrom")
    ] = pydantic.Field(default=None)
    """
    Where the supply is expected to come from.
    """

    deliver_to: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="deliverTo")
    ] = pydantic.Field(default=None)
    """
    Where the supply is destined to go.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
