# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .supply_delivery_status import SupplyDeliveryStatus
from .supply_delivery_supplied_item import SupplyDeliverySuppliedItem
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SupplyDelivery(BaseResource):
    """
    Record of delivery of what is supplied.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["SupplyDelivery"], FieldMetadata(alias="resourceType")
    ] = "SupplyDelivery"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for the supply delivery event that is used to identify it across multiple disparate systems.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan, proposal or order that is fulfilled in whole or in part by this event.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger event of which this particular event is a component or step.
    """

    status: typing.Optional[SupplyDeliveryStatus] = pydantic.Field(default=None)
    """
    A code specifying the state of the dispense event.
    """

    patient: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A link to a resource representing the person whom the delivered item is for.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.
    """

    supplied_item: typing_extensions.Annotated[
        typing.Optional[SupplyDeliverySuppliedItem], FieldMetadata(alias="suppliedItem")
    ] = pydantic.Field(default=None)
    """
    The item that is being delivered or has been supplied.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    The date or time(s) the activity occurred.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    The date or time(s) the activity occurred.
    """

    occurrence_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="occurrenceTiming")
    ] = pydantic.Field(default=None)
    """
    The date or time(s) the activity occurred.
    """

    supplier: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual responsible for dispensing the medication, supplier or device.
    """

    destination: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identification of the facility/location where the Supply was shipped to, as part of the dispense event.
    """

    receiver: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies the person who picked up the Supply.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
