# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .substance_specification_name import SubstanceSpecificationName
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .substance_specification_moiety import SubstanceSpecificationMoiety
from .substance_specification_property import SubstanceSpecificationProperty
from .substance_specification_structure import SubstanceSpecificationStructure
from .substance_specification_code import SubstanceSpecificationCode
from .substance_specification_molecular_weight import (
    SubstanceSpecificationMolecularWeight,
)
from .substance_specification_relationship import SubstanceSpecificationRelationship
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SubstanceSpecification(BaseResource):
    """
    The detailed description of a substance, typically at a level beyond what is used for prescribing.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["SubstanceSpecification"], FieldMetadata(alias="resourceType")
    ] = "SubstanceSpecification"
    identifier: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    Identifier by which this substance is known.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    High level categorization, e.g. polymer or nucleic acid.
    """

    status: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Status of substance within the catalogue e.g. approved.
    """

    domain: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    If the substance applies to only human or veterinary use.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Textual description of the substance.
    """

    source: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Supporting literature.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Textual comment about this record of a substance.
    """

    moiety: typing.Optional[typing.List[SubstanceSpecificationMoiety]] = pydantic.Field(
        default=None
    )
    """
    Moiety, for structural modifications.
    """

    property: typing.Optional[typing.List[SubstanceSpecificationProperty]] = (
        pydantic.Field(default=None)
    )
    """
    General specifications for this substance, including how it is related to other substances.
    """

    reference_information: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="referenceInformation")
    ] = pydantic.Field(default=None)
    """
    General information detailing this substance.
    """

    structure: typing.Optional[SubstanceSpecificationStructure] = pydantic.Field(
        default=None
    )
    """
    Structural information.
    """

    code: typing.Optional[typing.List[SubstanceSpecificationCode]] = pydantic.Field(
        default=None
    )
    """
    Codes associated with the substance.
    """

    name: typing.Optional[typing.List[SubstanceSpecificationName]] = pydantic.Field(
        default=None
    )
    """
    Names applicable to this substance.
    """

    molecular_weight: typing_extensions.Annotated[
        typing.Optional[typing.List[SubstanceSpecificationMolecularWeight]],
        FieldMetadata(alias="molecularWeight"),
    ] = pydantic.Field(default=None)
    """
    The molecular weight or weight range (for proteins, polymers or nucleic acids).
    """

    relationship: typing.Optional[typing.List[SubstanceSpecificationRelationship]] = (
        pydantic.Field(default=None)
    )
    """
    A link between this substance and another, with details of the relationship.
    """

    nucleic_acid: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="nucleicAcid")
    ] = pydantic.Field(default=None)
    """
    Data items specific to nucleic acids.
    """

    polymer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Data items specific to polymers.
    """

    protein: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Data items specific to proteins.
    """

    source_material: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="sourceMaterial")
    ] = pydantic.Field(default=None)
    """
    Material or taxonomic/anatomical source for the substance.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
