# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .substance_source_material_author import SubstanceSourceMaterialAuthor
from .substance_source_material_hybrid import SubstanceSourceMaterialHybrid
from .substance_source_material_organism_general import (
    SubstanceSourceMaterialOrganismGeneral,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SubstanceSourceMaterialOrganism(UniversalBaseModel):
    """
    Source material shall capture information on the taxonomic and anatomical origins as well as the fraction of a material that can result in or can be modified to form a substance. This set of data elements shall be used to define polymer substances isolated from biological matrices. Taxonomic and anatomical origins shall be described using a controlled vocabulary as required. This information is captured for naturally derived polymers ( . starch) and structurally diverse substances. For Organisms belonging to the Kingdom Plantae the Substance level defines the fresh material of a single species or infraspecies, the Herbal Drug and the Herbal preparation. For Herbal preparations, the fraction information will be captured at the Substance information level and additional information for herbal extracts will be captured at the Specified Substance Group 1 information level. See for further explanation the Substance Class: Structurally Diverse and the herbal annex.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    family: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The family of an organism shall be specified.
    """

    genus: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The genus of an organism shall be specified; refers to the Latin epithet of the genus element of the plant/animal scientific name; it is present in names for genera, species and infraspecies.
    """

    species: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The species of an organism shall be specified; refers to the Latin epithet of the species of the plant/animal; it is present in names for species and infraspecies.
    """

    intraspecific_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="intraspecificType")
    ] = pydantic.Field(default=None)
    """
    The Intraspecific type of an organism shall be specified.
    """

    intraspecific_description: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="intraspecificDescription")
    ] = pydantic.Field(default=None)
    """
    The intraspecific description of an organism shall be specified based on a controlled vocabulary. For Influenza Vaccine, the intraspecific description shall contain the syntax of the antigen in line with the WHO convention.
    """

    author: typing.Optional[typing.List[SubstanceSourceMaterialAuthor]] = (
        pydantic.Field(default=None)
    )
    """
    4.9.13.6.1 Author type (Conditional).
    """

    hybrid: typing.Optional[SubstanceSourceMaterialHybrid] = pydantic.Field(
        default=None
    )
    """
    4.9.13.8.1 Hybrid species maternal organism ID (Optional).
    """

    organism_general: typing_extensions.Annotated[
        typing.Optional[SubstanceSourceMaterialOrganismGeneral],
        FieldMetadata(alias="organismGeneral"),
    ] = pydantic.Field(default=None)
    """
    4.9.13.7.1 Kingdom (Conditional).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
