# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .substance_source_material_fraction_description import (
    SubstanceSourceMaterialFractionDescription,
)
from .substance_source_material_organism import SubstanceSourceMaterialOrganism
from .substance_source_material_part_description import (
    SubstanceSourceMaterialPartDescription,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SubstanceSourceMaterial(BaseResource):
    """
    Source material shall capture information on the taxonomic and anatomical origins as well as the fraction of a material that can result in or can be modified to form a substance. This set of data elements shall be used to define polymer substances isolated from biological matrices. Taxonomic and anatomical origins shall be described using a controlled vocabulary as required. This information is captured for naturally derived polymers ( . starch) and structurally diverse substances. For Organisms belonging to the Kingdom Plantae the Substance level defines the fresh material of a single species or infraspecies, the Herbal Drug and the Herbal preparation. For Herbal preparations, the fraction information will be captured at the Substance information level and additional information for herbal extracts will be captured at the Specified Substance Group 1 information level. See for further explanation the Substance Class: Structurally Diverse and the herbal annex.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["SubstanceSourceMaterial"], FieldMetadata(alias="resourceType")
    ] = "SubstanceSourceMaterial"
    source_material_class: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="sourceMaterialClass")
    ] = pydantic.Field(default=None)
    """
    General high level classification of the source material specific to the origin of the material.
    """

    source_material_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="sourceMaterialType")
    ] = pydantic.Field(default=None)
    """
    The type of the source material shall be specified based on a controlled vocabulary. For vaccines, this subclause refers to the class of infectious agent.
    """

    source_material_state: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="sourceMaterialState")
    ] = pydantic.Field(default=None)
    """
    The state of the source material when extracted.
    """

    organism_id: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="organismId")
    ] = pydantic.Field(default=None)
    """
    The unique identifier associated with the source material parent organism shall be specified.
    """

    organism_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="organismName")
    ] = pydantic.Field(default=None)
    """
    The organism accepted Scientific name shall be provided based on the organism taxonomy.
    """

    parent_substance_id: typing_extensions.Annotated[
        typing.Optional[typing.List[Identifier]],
        FieldMetadata(alias="parentSubstanceId"),
    ] = pydantic.Field(default=None)
    """
    The parent of the herbal drug Ginkgo biloba, Leaf is the substance ID of the substance (fresh) of Ginkgo biloba L. or Ginkgo biloba L. (Whole plant).
    """

    parent_substance_name: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="parentSubstanceName")
    ] = pydantic.Field(default=None)
    """
    The parent substance of the Herbal Drug, or Herbal preparation.
    """

    country_of_origin: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="countryOfOrigin"),
    ] = pydantic.Field(default=None)
    """
    The country where the plant material is harvested or the countries where the plasma is sourced from as laid down in accordance with the Plasma Master File. For “Plasma-derived substances” the attribute country of origin provides information about the countries used for the manufacturing of the Cryopoor plama or Crioprecipitate.
    """

    geographical_location: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="geographicalLocation")
    ] = pydantic.Field(default=None)
    """
    The place/region where the plant is harvested or the places/regions where the animal source material has its habitat.
    """

    development_stage: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="developmentStage")
    ] = pydantic.Field(default=None)
    """
    Stage of life for animals, plants, insects and microorganisms. This information shall be provided only when the substance is significantly different in these stages (e.g. foetal bovine serum).
    """

    fraction_description: typing_extensions.Annotated[
        typing.Optional[typing.List[SubstanceSourceMaterialFractionDescription]],
        FieldMetadata(alias="fractionDescription"),
    ] = pydantic.Field(default=None)
    """
    Many complex materials are fractions of parts of plants, animals, or minerals. Fraction elements are often necessary to define both Substances and Specified Group 1 Substances. For substances derived from Plants, fraction information will be captured at the Substance information level ( . Oils, Juices and Exudates). Additional information for Extracts, such as extraction solvent composition, will be captured at the Specified Substance Group 1 information level. For plasma-derived products fraction information will be captured at the Substance and the Specified Substance Group 1 levels.
    """

    organism: typing.Optional[SubstanceSourceMaterialOrganism] = pydantic.Field(
        default=None
    )
    """
    This subclause describes the organism which the substance is derived from. For vaccines, the parent organism shall be specified based on these subclause elements. As an example, full taxonomy will be described for the Substance Name: ., Leaf.
    """

    part_description: typing_extensions.Annotated[
        typing.Optional[typing.List[SubstanceSourceMaterialPartDescription]],
        FieldMetadata(alias="partDescription"),
    ] = pydantic.Field(default=None)
    """
    To do.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
