# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SubstanceProteinSubunit(UniversalBaseModel):
    """
    A SubstanceProtein is defined as a single unit of a linear amino acid sequence, or a combination of subunits that are either covalently linked or have a defined invariant stoichiometric relationship. This includes all synthetic, recombinant and purified SubstanceProteins of defined sequence, whether the use is therapeutic or prophylactic. This set of elements will be used to describe albumins, coagulation factors, cytokines, growth factors, peptide/SubstanceProtein hormones, enzymes, toxins, toxoids, recombinant vaccines, and immunomodulators.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    subunit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Index of primary sequences of amino acids linked through peptide bonds in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.
    """

    sequence: typing.Optional[str] = pydantic.Field(default=None)
    """
    The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.
    """

    length: typing.Optional[int] = pydantic.Field(default=None)
    """
    Length of linear sequences of amino acids contained in the subunit.
    """

    sequence_attachment: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="sequenceAttachment")
    ] = pydantic.Field(default=None)
    """
    The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.
    """

    n_terminal_modification_id: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="nTerminalModificationId")
    ] = pydantic.Field(default=None)
    """
    Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.
    """

    n_terminal_modification: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="nTerminalModification")
    ] = pydantic.Field(default=None)
    """
    The name of the fragment modified at the N-terminal of the SubstanceProtein shall be specified.
    """

    c_terminal_modification_id: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="cTerminalModificationId")
    ] = pydantic.Field(default=None)
    """
    Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.
    """

    c_terminal_modification: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="cTerminalModification")
    ] = pydantic.Field(default=None)
    """
    The modification at the C-terminal shall be specified.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
