# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .substance_nucleic_acid_subunit import SubstanceNucleicAcidSubunit
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SubstanceNucleicAcid(BaseResource):
    """
    Nucleic acids are defined by three distinct elements: the base, sugar and linkage. Individual substance/moiety IDs will be created for each of these elements. The nucleotide sequence will be always entered in the 5’-3’ direction.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["SubstanceNucleicAcid"], FieldMetadata(alias="resourceType")
    ] = "SubstanceNucleicAcid"
    sequence_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="sequenceType")
    ] = pydantic.Field(default=None)
    """
    The type of the sequence shall be specified based on a controlled vocabulary.
    """

    number_of_subunits: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="numberOfSubunits")
    ] = pydantic.Field(default=None)
    """
    The number of linear sequences of nucleotides linked through phosphodiester bonds shall be described. Subunits would be strands of nucleic acids that are tightly associated typically through Watson-Crick base pairing. NOTE: If not specified in the reference source, the assumption is that there is 1 subunit.
    """

    area_of_hybridisation: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="areaOfHybridisation")
    ] = pydantic.Field(default=None)
    """
    The area of hybridisation shall be described if applicable for double stranded RNA or DNA. The number associated with the subunit followed by the number associated to the residue shall be specified in increasing order. The underscore “” shall be used as separator as follows: “Subunitnumber Residue”.
    """

    oligo_nucleotide_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="oligoNucleotideType")
    ] = pydantic.Field(default=None)
    """
    (TBC).
    """

    subunit: typing.Optional[typing.List[SubstanceNucleicAcidSubunit]] = pydantic.Field(
        default=None
    )
    """
    Subunits are listed in order of decreasing length; sequences of the same length will be ordered by molecular weight; subunits that have identical sequences will be repeated multiple times.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
