# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .substance_status import SubstanceStatus
from .substance_instance import SubstanceInstance
from .substance_ingredient import SubstanceIngredient
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Substance(BaseResource):
    """
    A homogeneous material with a definite composition.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Substance"], FieldMetadata(alias="resourceType")
    ] = "Substance"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique identifier for the substance.
    """

    status: typing.Optional[SubstanceStatus] = pydantic.Field(default=None)
    """
    A code to indicate if the substance is actively used.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A code that classifies the general type of substance. This is used for searching, sorting and display purposes.
    """

    code: CodeableConcept = pydantic.Field()
    """
    A code (or set of codes) that identify this substance.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of the substance - its appearance, handling requirements, and other usage notes.
    """

    instance: typing.Optional[typing.List[SubstanceInstance]] = pydantic.Field(
        default=None
    )
    """
    Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.
    """

    ingredient: typing.Optional[typing.List[SubstanceIngredient]] = pydantic.Field(
        default=None
    )
    """
    A substance can be composed of other substances.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
