# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .subscription_channel_type import SubscriptionChannelType
from .url import Url
from .code import Code
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SubscriptionChannel(UniversalBaseModel):
    """
    The subscription resource is used to define a push-based subscription from a server to another system. Once a subscription is registered with the server, the server checks every resource that is created or updated, and if the resource matches the given criteria, it sends a message on the defined "channel" so that another system can take an appropriate action.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    type: typing.Optional[SubscriptionChannelType] = pydantic.Field(default=None)
    """
    The type of channel to send notifications on.
    """

    endpoint: typing.Optional[Url] = pydantic.Field(default=None)
    """
    The url that describes the actual end-point to send messages to.
    """

    payload: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The mime type to send the payload in - either application/fhir+xml, or application/fhir+json. If the payload is not present, then there is no payload in the notification, just a notification. The mime type "text/plain" may also be used for Email and SMS subscriptions.
    """

    header: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Additional headers / information to send as part of the notification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
