# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .subscription_status import SubscriptionStatus
import pydantic
from .instant import Instant
from .subscription_channel import SubscriptionChannel
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Subscription(BaseResource):
    """
    The subscription resource is used to define a push-based subscription from a server to another system. Once a subscription is registered with the server, the server checks every resource that is created or updated, and if the resource matches the given criteria, it sends a message on the defined "channel" so that another system can take an appropriate action.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Subscription"], FieldMetadata(alias="resourceType")
    ] = "Subscription"
    status: typing.Optional[SubscriptionStatus] = pydantic.Field(default=None)
    """
    The status of the subscription, which marks the server state for managing the subscription.
    """

    contact: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.
    """

    end: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The time for the server to turn the subscription off.
    """

    reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of why this subscription is defined.
    """

    criteria: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rules that the server should use to determine when to generate notifications for this subscription.
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    A record of the last error that occurred when the server processed a notification.
    """

    channel: SubscriptionChannel = pydantic.Field()
    """
    Details where to send notifications when resources are received that meet the criteria.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
