# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .structure_definition_status import StructureDefinitionStatus
from .date_time import DateTime
from .markdown import Markdown
from .structure_definition_fhir_version import StructureDefinitionFhirVersion
from .structure_definition_mapping import StructureDefinitionMapping
from .structure_definition_kind import StructureDefinitionKind
from .structure_definition_context import StructureDefinitionContext
from .canonical import Canonical
from .structure_definition_derivation import StructureDefinitionDerivation
from .structure_definition_snapshot import StructureDefinitionSnapshot
from .structure_definition_differential import StructureDefinitionDifferential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class StructureDefinition(BaseResource):
    """
    A definition of a FHIR structure. This resource is used to describe the underlying resources, data types defined in FHIR, and also for describing extensions and constraints on resources and data types.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["StructureDefinition"], FieldMetadata(alias="resourceType")
    ] = "StructureDefinition"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this structure definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this structure definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the structure definition is stored on different servers.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this structure definition when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the structure definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the structure definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the structure definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the structure definition.
    """

    status: typing.Optional[StructureDefinitionStatus] = pydantic.Field(default=None)
    """
    The status of this structure definition. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this structure definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the structure definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the structure definition changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the structure definition.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the structure definition from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate structure definition instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the structure definition is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this structure definition is needed and why it has been designed as it has.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure definition.
    """

    keyword: typing.Optional[typing.List[Coding]] = pydantic.Field(default=None)
    """
    A set of key words or terms from external terminologies that may be used to assist with indexing and searching of templates nby describing the use of this structure definition, or the content it describes.
    """

    fhir_version: typing_extensions.Annotated[
        typing.Optional[StructureDefinitionFhirVersion],
        FieldMetadata(alias="fhirVersion"),
    ] = pydantic.Field(default=None)
    """
    The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 4.0.1. for this version.
    """

    mapping: typing.Optional[typing.List[StructureDefinitionMapping]] = pydantic.Field(
        default=None
    )
    """
    An external specification that the content is mapped to.
    """

    kind: typing.Optional[StructureDefinitionKind] = pydantic.Field(default=None)
    """
    Defines the kind of structure that this definition is describing.
    """

    abstract: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether structure this definition describes is abstract or not - that is, whether the structure is not intended to be instantiated. For Resources and Data types, abstract types will never be exchanged between systems.
    """

    context: typing.Optional[typing.List[StructureDefinitionContext]] = pydantic.Field(
        default=None
    )
    """
    Identifies the types of resource or data type elements to which the extension can be applied.
    """

    context_invariant: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="contextInvariant")
    ] = pydantic.Field(default=None)
    """
    A set of rules as FHIRPath Invariants about when the extension can be used (e.g. co-occurrence variants for the extension). All the rules must be true.
    """

    type: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    The type this structure describes. If the derivation kind is 'specialization' then this is the master definition for a type, and there is always one of these (a data type, an extension, a resource, including abstract ones). Otherwise the structure definition is a constraint on the stated type (and in this case, the type cannot be an abstract type). References are URLs that are relative to http://hl7.org/fhir/StructureDefinition e.g. "string" is a reference to http://hl7.org/fhir/StructureDefinition/string. Absolute URLs are only allowed in logical models.
    """

    base_definition: typing_extensions.Annotated[
        typing.Optional[Canonical], FieldMetadata(alias="baseDefinition")
    ] = pydantic.Field(default=None)
    """
    An absolute URI that is the base structure from which this type is derived, either by specialization or constraint.
    """

    derivation: typing.Optional[StructureDefinitionDerivation] = pydantic.Field(
        default=None
    )
    """
    How the type relates to the baseDefinition.
    """

    snapshot: typing.Optional[StructureDefinitionSnapshot] = pydantic.Field(
        default=None
    )
    """
    A snapshot view is expressed in a standalone form that can be used and interpreted without considering the base StructureDefinition.
    """

    differential: typing.Optional[StructureDefinitionDifferential] = pydantic.Field(
        default=None
    )
    """
    A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
