# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .specimen_status import SpecimenStatus
from .date_time import DateTime
from .specimen_collection import SpecimenCollection
from .specimen_processing import SpecimenProcessing
from .specimen_container import SpecimenContainer
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Specimen(BaseResource):
    """
    A sample to be used for analysis.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Specimen"], FieldMetadata(alias="resourceType")
    ] = "Specimen"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Id for specimen.
    """

    accession_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="accessionIdentifier")
    ] = pydantic.Field(default=None)
    """
    The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.
    """

    status: typing.Optional[SpecimenStatus] = pydantic.Field(default=None)
    """
    The availability of the specimen.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The kind of material that forms the specimen.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance or a device.
    """

    received_time: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="receivedTime")
    ] = pydantic.Field(default=None)
    """
    Time when specimen was received for processing or testing.
    """

    parent: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.
    """

    request: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Details concerning a service request that required a specimen to be collected.
    """

    collection: typing.Optional[SpecimenCollection] = pydantic.Field(default=None)
    """
    Details concerning the specimen collection.
    """

    processing: typing.Optional[typing.List[SpecimenProcessing]] = pydantic.Field(
        default=None
    )
    """
    Details concerning processing and processing steps for the specimen.
    """

    container: typing.Optional[typing.List[SpecimenContainer]] = pydantic.Field(
        default=None
    )
    """
    The container holding the specimen. The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.
    """

    condition: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A mode or state of being that describes the nature of the specimen.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
