# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .slot_status import SlotStatus
from .instant import Instant
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Slot(BaseResource):
    """
    A slot of time on a schedule that may be available for booking appointments.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Slot"], FieldMetadata(alias="resourceType")
    ] = "Slot"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    External Ids for this item.
    """

    service_category: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceCategory"),
    ] = pydantic.Field(default=None)
    """
    A broad categorization of the service that is to be performed during this appointment.
    """

    service_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceType"),
    ] = pydantic.Field(default=None)
    """
    The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource.
    """

    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The specialty of a practitioner that would be required to perform the service requested in this appointment.
    """

    appointment_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="appointmentType")
    ] = pydantic.Field(default=None)
    """
    The style of appointment or patient that may be booked in the slot (not service type).
    """

    schedule: Reference = pydantic.Field()
    """
    The schedule resource that this slot defines an interval of status information.
    """

    status: typing.Optional[SlotStatus] = pydantic.Field(default=None)
    """
    busy | free | busy-unavailable | busy-tentative | entered-in-error.
    """

    start: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    Date/Time that the slot is to begin.
    """

    end: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    Date/Time that the slot is to conclude.
    """

    overbooked: typing.Optional[bool] = pydantic.Field(default=None)
    """
    This slot has already been overbooked, appointments are unlikely to be accepted for this time.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Comments on the slot to describe any extended information. Such as custom constraints on the slot.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
