# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .instant import Instant
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .base_64_binary import Base64Binary
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class Signature(UniversalBaseModel):
    """
    A signature along with supporting context. The signature may be a digital signature that is cryptographic in nature, or some other signature acceptable to the domain. This other signature may be as simple as a graphical image representing a hand-written signature, or a signature ceremony Different signature approaches have different utilities.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    type: typing.List["Coding"] = pydantic.Field()
    """
    An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.
    """

    when: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    When the digital signature was signed.
    """

    who: "Reference" = pydantic.Field()
    """
    A reference to an application-usable description of the identity that signed (e.g. the signature used their private key).
    """

    on_behalf_of: typing_extensions.Annotated[
        typing.Optional["Reference"], FieldMetadata(alias="onBehalfOf")
    ] = pydantic.Field(default=None)
    """
    A reference to an application-usable description of the identity that is represented by the signature.
    """

    target_format: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="targetFormat")
    ] = pydantic.Field(default=None)
    """
    A mime type that indicates the technical format of the target resources signed by the signature.
    """

    sig_format: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="sigFormat")
    ] = pydantic.Field(default=None)
    """
    A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jose for JWS, and image/\* for a graphical image of a signature, etc.
    """

    data: typing.Optional[Base64Binary] = pydantic.Field(default=None)
    """
    The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement import DataRequirement  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .meta import Meta  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .sampled_data import SampledData  # noqa: E402
from .timing import Timing  # noqa: E402
from .timing_repeat import TimingRepeat  # noqa: E402
from .trigger_definition import TriggerDefinition  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(Signature)
