# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ServiceRequest(BaseResource):
    """
    A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ServiceRequest"], FieldMetadata(alias="resourceType")
    ] = "ServiceRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this order instance by the orderer and/or the receiver and/or order fulfiller.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this ServiceRequest.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this ServiceRequest.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    Plan/proposal/order fulfilled by this request.
    """

    replaces: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The request takes the place of the referenced completed or terminated request(s).
    """

    requisition: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    A shared identifier common to all service requests that were authorized more or less simultaneously by a single author, representing the composite or group identifier.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the order.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Whether the request is a proposal, plan, an original order or a reflex order.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A code that classifies the service for searching, sorting and display purposes (e.g. "Surgical Procedure").
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the ServiceRequest should be addressed with respect to other requests.
    """

    do_not_perform: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="doNotPerform")
    ] = pydantic.Field(default=None)
    """
    Set this to true if the record is saying that the service/procedure should NOT be performed.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code that identifies a particular service (i.e., procedure, diagnostic investigation, or panel of investigations) that have been requested.
    """

    order_detail: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="orderDetail"),
    ] = pydantic.Field(default=None)
    """
    Additional details and instructions about the how the services are to be delivered. For example, and order for a urinary catheter may have an order detail for an external or indwelling catheter, or an order for a bandage may require additional instructions specifying how the bandage should be applied.
    """

    quantity_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="quantityQuantity")
    ] = pydantic.Field(default=None)
    """
    An amount of service being requested which can be a quantity ( for example $1,500 home modification), a ratio ( for example, 20 half day visits per month), or a range (2.0 to 1.8 Gy per fraction).
    """

    quantity_ratio: typing_extensions.Annotated[
        typing.Optional[Ratio], FieldMetadata(alias="quantityRatio")
    ] = pydantic.Field(default=None)
    """
    An amount of service being requested which can be a quantity ( for example $1,500 home modification), a ratio ( for example, 20 half day visits per month), or a range (2.0 to 1.8 Gy per fraction).
    """

    quantity_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="quantityRange")
    ] = pydantic.Field(default=None)
    """
    An amount of service being requested which can be a quantity ( for example $1,500 home modification), a ratio ( for example, 20 half day visits per month), or a range (2.0 to 1.8 Gy per fraction).
    """

    subject: Reference = pydantic.Field()
    """
    On whom or what the service is to be performed. This is usually a human patient, but can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    An encounter that provides additional information about the healthcare context in which this request is made.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    The date/time at which the requested service should occur.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    The date/time at which the requested service should occur.
    """

    occurrence_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="occurrenceTiming")
    ] = pydantic.Field(default=None)
    """
    The date/time at which the requested service should occur.
    """

    as_needed_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="asNeededBoolean")
    ] = pydantic.Field(default=None)
    """
    If a CodeableConcept is present, it indicates the pre-condition for performing the service. For example "pain", "on flare-up", etc.
    """

    as_needed_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="asNeededCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    If a CodeableConcept is present, it indicates the pre-condition for performing the service. For example "pain", "on flare-up", etc.
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    When the request transitioned to being actionable.
    """

    requester: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual who initiated the request and has responsibility for its activation.
    """

    performer_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="performerType")
    ] = pydantic.Field(default=None)
    """
    Desired type of performer for doing the requested service.
    """

    performer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The desired performer for doing the requested service. For example, the surgeon, dermatopathologist, endoscopist, etc.
    """

    location_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="locationCode"),
    ] = pydantic.Field(default=None)
    """
    The preferred location(s) where the procedure should actually happen in coded or free text form. E.g. at home or nursing day care center.
    """

    location_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="locationReference"),
    ] = pydantic.Field(default=None)
    """
    A reference to the the preferred location(s) where the procedure should actually happen. E.g. at home or nursing day care center.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    An explanation or justification for why this service is being requested in coded or textual form. This is often for billing purposes. May relate to the resources referred to in `supportingInfo`.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource that provides a justification for why this service is being requested. May relate to the resources referred to in `supportingInfo`.
    """

    insurance: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be needed for delivering the requested service.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="supportingInfo")
    ] = pydantic.Field(default=None)
    """
    Additional clinical information about the patient or specimen that may influence the services or their interpretations. This information includes diagnosis, clinical findings and other observations. In laboratory ordering these are typically referred to as "ask at order entry questions (AOEs)". This includes observations explicitly requested by the producer (filler) to provide context or supporting information needed to complete the order. For example, reporting the amount of inspired oxygen for blood gas measurements.
    """

    specimen: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    One or more specimens that the laboratory procedure will use.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Anatomic location where the procedure should be performed. This is the target site.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Any other notes and comments made about the service request. For example, internal billing notes.
    """

    patient_instruction: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patientInstruction")
    ] = pydantic.Field(default=None)
    """
    Instructions in terms that are understood by the patient or consumer.
    """

    relevant_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="relevantHistory")
    ] = pydantic.Field(default=None)
    """
    Key events in the history of the request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
