# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Schedule(BaseResource):
    """
    A container for slots of time that may be available for booking appointments.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Schedule"], FieldMetadata(alias="resourceType")
    ] = "Schedule"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    External Ids for this item.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this schedule record is in active use or should not be used (such as was entered in error).
    """

    service_category: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceCategory"),
    ] = pydantic.Field(default=None)
    """
    A broad categorization of the service that is to be performed during this appointment.
    """

    service_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceType"),
    ] = pydantic.Field(default=None)
    """
    The specific service that is to be performed during this appointment.
    """

    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The specialty of a practitioner that would be required to perform the service requested in this appointment.
    """

    actor: typing.List[Reference] = pydantic.Field()
    """
    Slots that reference this schedule resource provide the availability details to these referenced resource(s).
    """

    planning_horizon: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="planningHorizon")
    ] = pydantic.Field(default=None)
    """
    The period of time that the slots that reference this Schedule resource cover (even if none exist). These cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a "template" for planning outside these dates.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Comments on the availability to describe any extended information. Such as custom constraints on the slots that may be associated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
