# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .decimal import Decimal
import typing_extensions
from ...core.serialization import FieldMetadata
from .positive_int import PositiveInt
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class SampledData(UniversalBaseModel):
    """
    A series of measurements taken by a device, with upper and lower limits. There may be more than one dimension in the data.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    origin: "Quantity" = pydantic.Field()
    """
    The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.
    """

    period: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    The length of time between sampling times, measured in milliseconds.
    """

    factor: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    A correction factor that is applied to the sampled data points before they are added to the origin.
    """

    lower_limit: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="lowerLimit")
    ] = pydantic.Field(default=None)
    """
    The lower limit of detection of the measured points. This is needed if any of the data points have the value "L" (lower than detection limit).
    """

    upper_limit: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="upperLimit")
    ] = pydantic.Field(default=None)
    """
    The upper limit of detection of the measured points. This is needed if any of the data points have the value "U" (higher than detection limit).
    """

    dimensions: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.
    """

    data: typing.Optional[str] = pydantic.Field(default=None)
    """
    A series of data points which are decimal values separated by a single space (character u20). The special values "E" (error), "L" (below detection limit) and "U" (above detection limit) can also be used in place of a decimal value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement import DataRequirement  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .meta import Meta  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .signature import Signature  # noqa: E402
from .timing import Timing  # noqa: E402
from .timing_repeat import TimingRepeat  # noqa: E402
from .trigger_definition import TriggerDefinition  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(SampledData)
