# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .risk_assessment_prediction import RiskAssessmentPrediction
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RiskAssessment(BaseResource):
    """
    An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["RiskAssessment"], FieldMetadata(alias="resourceType")
    ] = "RiskAssessment"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifier assigned to the risk assessment.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A reference to the request that is fulfilled by this risk assessment.
    """

    parent: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A reference to a resource that this risk assessment is part of, such as a Procedure.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the RiskAssessment, using the same statuses as an Observation.
    """

    method: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The algorithm, process or mechanism used to evaluate the risk.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The type of the risk assessment performed.
    """

    subject: Reference = pydantic.Field()
    """
    The patient or group the risk assessment applies to.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter where the assessment was performed.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    The date (and possibly time) the risk assessment was performed.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    The date (and possibly time) the risk assessment was performed.
    """

    condition: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    For assessments or prognosis specific to a particular condition, indicates the condition being assessed.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The provider or software application that performed the assessment.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    The reason the risk assessment was performed.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Resources supporting the reason the risk assessment was performed.
    """

    basis: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Indicates the source data considered as part of the assessment (for example, FamilyHistory, Observations, Procedures, Conditions, etc.).
    """

    prediction: typing.Optional[typing.List[RiskAssessmentPrediction]] = pydantic.Field(
        default=None
    )
    """
    Describes the expected outcome for the subject.
    """

    mitigation: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of the steps that might be taken to reduce the identified risk(s).
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Additional comments about the risk assessment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
