# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .research_subject_status import ResearchSubjectStatus
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ResearchSubject(BaseResource):
    """
    A physical entity which is the primary unit of operational and/or administrative interest in a study.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ResearchSubject"], FieldMetadata(alias="resourceType")
    ] = "ResearchSubject"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this research subject for a study.
    """

    status: typing.Optional[ResearchSubjectStatus] = pydantic.Field(default=None)
    """
    The current state of the subject.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The dates the subject began and ended their participation in the study.
    """

    study: Reference = pydantic.Field()
    """
    Reference to the study the subject is participating in.
    """

    individual: Reference = pydantic.Field()
    """
    The record of the person or animal who is involved in the study.
    """

    assigned_arm: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="assignedArm")
    ] = pydantic.Field(default=None)
    """
    The name of the arm in the study the subject is expected to follow as part of this study.
    """

    actual_arm: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="actualArm")
    ] = pydantic.Field(default=None)
    """
    The name of the arm in the study the subject actually followed as part of this study.
    """

    consent: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A record of the patient's informed agreement to participate in the study.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
