# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .research_study_status import ResearchStudyStatus
from .markdown import Markdown
from .research_study_arm import ResearchStudyArm
from .research_study_objective import ResearchStudyObjective
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ResearchStudy(BaseResource):
    """
    A process where a researcher or organization plans and then executes a series of steps intended to increase the field of healthcare-related knowledge. This includes studies of safety, efficacy, comparative effectiveness and other information about medications, devices, therapies and other interventional and investigative techniques. A ResearchStudy involves the gathering of information about human or animal subjects.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ResearchStudy"], FieldMetadata(alias="resourceType")
    ] = "ResearchStudy"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this research study by the sponsor or other systems.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive user-friendly label for the study.
    """

    protocol: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The set of steps expected to be performed as part of the execution of the study.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger research study of which this particular study is a component or step.
    """

    status: typing.Optional[ResearchStudyStatus] = pydantic.Field(default=None)
    """
    The current state of the study.
    """

    primary_purpose_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="primaryPurposeType")
    ] = pydantic.Field(default=None)
    """
    The type of study based upon the intent of the study's activities. A classification of the intent of the study.
    """

    phase: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.
    """

    focus: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.
    """

    condition: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The condition that is the focus of the study. For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion "healthy volunteer", but the target condition code would be a Lupus SNOMED code.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in learning more about or engaging with the study.
    """

    related_artifact: typing_extensions.Annotated[
        typing.Optional[typing.List[RelatedArtifact]],
        FieldMetadata(alias="relatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    Citations, references and other related documents.
    """

    keyword: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Key terms to aid in searching for or filtering the study.
    """

    location: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Indicates a country, state or other region where the study is taking place.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A full description of how the study is being conducted.
    """

    enrollment: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Reference to a Group that defines the criteria for and quantity of subjects participating in the study. E.g. " 200 female Europeans between the ages of 20 and 45 with early onset diabetes".
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    Identifies the start date and the expected (or actual, depending on status) end date for the study.
    """

    sponsor: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    An organization that initiates the investigation and is legally responsible for the study.
    """

    principal_investigator: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="principalInvestigator")
    ] = pydantic.Field(default=None)
    """
    A researcher in a study who oversees multiple aspects of the study, such as concept development, protocol writing, protocol submission for IRB approval, participant recruitment, informed consent, data collection, analysis, interpretation and presentation.
    """

    site: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    A facility in which study activities are conducted.
    """

    reason_stopped: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="reasonStopped")
    ] = pydantic.Field(default=None)
    """
    A description and/or code explaining the premature termination of the study.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the study by the performer, subject or other participants.
    """

    arm: typing.Optional[typing.List[ResearchStudyArm]] = pydantic.Field(default=None)
    """
    Describes an expected sequence of events for one of the participants of a study. E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.
    """

    objective: typing.Optional[typing.List[ResearchStudyObjective]] = pydantic.Field(
        default=None
    )
    """
    A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
