# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .research_element_definition_characteristic_study_effective_group_measure import (
    ResearchElementDefinitionCharacteristicStudyEffectiveGroupMeasure,
)
from .research_element_definition_characteristic_participant_effective_group_measure import (
    ResearchElementDefinitionCharacteristicParticipantEffectiveGroupMeasure,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ResearchElementDefinitionCharacteristic(UniversalBaseModel):
    """
    The ResearchElementDefinition resource describes a "PICO" element that knowledge (evidence, assertion, recommendation) is about.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    definition_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="definitionCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).
    """

    definition_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="definitionCanonical")
    ] = pydantic.Field(default=None)
    """
    Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).
    """

    definition_expression: typing_extensions.Annotated[
        typing.Optional[Expression], FieldMetadata(alias="definitionExpression")
    ] = pydantic.Field(default=None)
    """
    Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).
    """

    definition_data_requirement: typing_extensions.Annotated[
        typing.Optional[DataRequirement],
        FieldMetadata(alias="definitionDataRequirement"),
    ] = pydantic.Field(default=None)
    """
    Define members of the research element using Codes (such as condition, medication, or observation), Expressions ( using an expression language such as FHIRPath or CQL) or DataRequirements (such as Diabetes diagnosis onset in the last year).
    """

    usage_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="usageContext")
    ] = pydantic.Field(default=None)
    """
    Use UsageContext to define the members of the population, such as Age Ranges, Genders, Settings.
    """

    exclude: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, members with this characteristic are excluded from the element.
    """

    unit_of_measure: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="unitOfMeasure")
    ] = pydantic.Field(default=None)
    """
    Specifies the UCUM unit for the outcome.
    """

    study_effective_description: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="studyEffectiveDescription")
    ] = pydantic.Field(default=None)
    """
    A narrative description of the time period the study covers.
    """

    study_effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="studyEffectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    study_effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="studyEffectivePeriod")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    study_effective_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="studyEffectiveDuration")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    study_effective_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="studyEffectiveTiming")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    study_effective_time_from_start: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="studyEffectiveTimeFromStart")
    ] = pydantic.Field(default=None)
    """
    Indicates duration from the study initiation.
    """

    study_effective_group_measure: typing_extensions.Annotated[
        typing.Optional[
            ResearchElementDefinitionCharacteristicStudyEffectiveGroupMeasure
        ],
        FieldMetadata(alias="studyEffectiveGroupMeasure"),
    ] = pydantic.Field(default=None)
    """
    Indicates how elements are aggregated within the study effective period.
    """

    participant_effective_description: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="participantEffectiveDescription")
    ] = pydantic.Field(default=None)
    """
    A narrative description of the time period the study covers.
    """

    participant_effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="participantEffectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    participant_effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="participantEffectivePeriod")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    participant_effective_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="participantEffectiveDuration")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    participant_effective_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="participantEffectiveTiming")
    ] = pydantic.Field(default=None)
    """
    Indicates what effective period the study covers.
    """

    participant_effective_time_from_start: typing_extensions.Annotated[
        typing.Optional[Duration],
        FieldMetadata(alias="participantEffectiveTimeFromStart"),
    ] = pydantic.Field(default=None)
    """
    Indicates duration from the participant's study entry.
    """

    participant_effective_group_measure: typing_extensions.Annotated[
        typing.Optional[
            ResearchElementDefinitionCharacteristicParticipantEffectiveGroupMeasure
        ],
        FieldMetadata(alias="participantEffectiveGroupMeasure"),
    ] = pydantic.Field(default=None)
    """
    Indicates how elements are aggregated within the study effective period.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
