# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .request_group_condition import RequestGroupCondition
from .request_group_related_action import RequestGroupRelatedAction
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class RequestGroupAction(UniversalBaseModel):
    """
    A group of related requests that can be used to capture intended activities that have inter-dependencies such as "give this medication after that one".
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    prefix: typing.Optional[str] = pydantic.Field(default=None)
    """
    A user-visible prefix for the action.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the action displayed to a user.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short description of the action used to provide a summary to display to the user.
    """

    text_equivalent: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="textEquivalent")
    ] = pydantic.Field(default=None)
    """
    A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the action should be addressed with respect to other actions.
    """

    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a section of a documentation template.
    """

    documentation: typing.Optional[typing.List[RelatedArtifact]] = pydantic.Field(
        default=None
    )
    """
    Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.
    """

    condition: typing.Optional[typing.List[RequestGroupCondition]] = pydantic.Field(
        default=None
    )
    """
    An expression that describes applicability criteria, or start/stop conditions for the action.
    """

    related_action: typing_extensions.Annotated[
        typing.Optional[typing.List[RequestGroupRelatedAction]],
        FieldMetadata(alias="relatedAction"),
    ] = pydantic.Field(default=None)
    """
    A relationship to another action such as "before" or "30-60 minutes after start of".
    """

    timing_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="timingDateTime")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="timingAge")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="timingPeriod")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="timingDuration")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="timingRange")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="timingTiming")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    participant: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The participant that should perform or be responsible for this action.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The type of action to perform (create, update, remove).
    """

    grouping_behavior: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="groupingBehavior")
    ] = pydantic.Field(default=None)
    """
    Defines the grouping behavior for the action and its children.
    """

    selection_behavior: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="selectionBehavior")
    ] = pydantic.Field(default=None)
    """
    Defines the selection behavior for the action and its children.
    """

    required_behavior: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="requiredBehavior")
    ] = pydantic.Field(default=None)
    """
    Defines expectations around whether an action is required.
    """

    precheck_behavior: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="precheckBehavior")
    ] = pydantic.Field(default=None)
    """
    Defines whether the action should usually be preselected.
    """

    cardinality_behavior: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="cardinalityBehavior")
    ] = pydantic.Field(default=None)
    """
    Defines whether the action can be selected multiple times.
    """

    resource: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The resource that is the target of the action (e.g. CommunicationRequest).
    """

    action: typing.Optional[typing.List["RequestGroupAction"]] = pydantic.Field(
        default=None
    )
    """
    Sub actions.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(RequestGroupAction)
