# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .request_group_action import RequestGroupAction
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RequestGroup(BaseResource):
    """
    A group of related requests that can be used to capture intended activities that have inter-dependencies such as "give this medication after that one".
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["RequestGroup"], FieldMetadata(alias="resourceType")
    ] = "RequestGroup"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Allows a service to provide a unique, business identifier for the request.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    A canonical URL referencing a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    A URL referencing an externally defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan, proposal or order that is fulfilled in whole or in part by this request.
    """

    replaces: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Completed or terminated request(s) whose function is taken by this new request.
    """

    group_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="groupIdentifier")
    ] = pydantic.Field(default=None)
    """
    A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The current state of the request. For request groups, the status reflects the status of all the requests in the group.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the level of authority/intentionality associated with the request and where the request fits into the workflow chain.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the request should be addressed with respect to other requests.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code that identifies what the overall request group is.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The subject for which the request group was created.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Describes the context of the request group, if any.
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    Indicates when the request group was created.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Provides a reference to the author of the request group.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Describes the reason for the request group in coded or textual form.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource whose existence justifies this request group.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Provides a mechanism to communicate additional information about the response.
    """

    action: typing.Optional[typing.List[RequestGroupAction]] = pydantic.Field(
        default=None
    )
    """
    The actions, if any, produced by the evaluation of the artifact.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
