# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .related_person_gender import RelatedPersonGender
import datetime as dt
from .related_person_communication import RelatedPersonCommunication
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RelatedPerson(BaseResource):
    """
    Information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["RelatedPerson"], FieldMetadata(alias="resourceType")
    ] = "RelatedPerson"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for a person within a particular scope.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this related person record is in active use.
    """

    patient: Reference = pydantic.Field()
    """
    The patient this person is related to.
    """

    relationship: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The nature of the relationship between a patient and the related person.
    """

    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(default=None)
    """
    A name associated with the person.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    A contact detail for the person, e.g. a telephone number or an email address.
    """

    gender: typing.Optional[RelatedPersonGender] = pydantic.Field(default=None)
    """
    Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.
    """

    birth_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="birthDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the related person was born.
    """

    address: typing.Optional[typing.List[Address]] = pydantic.Field(default=None)
    """
    Address where the related person can be contacted or visited.
    """

    photo: typing.Optional[typing.List[Attachment]] = pydantic.Field(default=None)
    """
    Image of the person.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period of time during which this relationship is or was active. If there are no dates defined, then the interval is unknown.
    """

    communication: typing.Optional[typing.List[RelatedPersonCommunication]] = (
        pydantic.Field(default=None)
    )
    """
    A language which may be used to communicate with about the patient's health.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
