# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .questionnaire_response_answer import QuestionnaireResponseAnswer
from .questionnaire_response_item import QuestionnaireResponseItem
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .questionnaire_response_status import QuestionnaireResponseStatus
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class QuestionnaireResponse(BaseResource):
    """
    A structured set of questions and their answers. The questions are ordered and grouped into coherent subsets, corresponding to the structure of the grouping of the questionnaire being responded to.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["QuestionnaireResponse"], FieldMetadata(alias="resourceType")
    ] = "QuestionnaireResponse"
    identifier: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    A business identifier assigned to a particular completed (or partially completed) questionnaire.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    The order, proposal or plan that is fulfilled in whole or in part by this QuestionnaireResponse. For example, a ServiceRequest seeking an intake assessment or a decision support recommendation to assess for post-partum depression.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A procedure or observation that this questionnaire was performed as part of the execution of. For example, the surgery a checklist was executed as part of.
    """

    questionnaire: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    The Questionnaire that defines and organizes the questions for which answers are being provided.
    """

    status: typing.Optional[QuestionnaireResponseStatus] = pydantic.Field(default=None)
    """
    The position of the questionnaire response within its overall lifecycle.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The subject of the questionnaire response. This could be a patient, organization, practitioner, device, etc. This is who/what the answers apply to, but is not necessarily the source of information.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this questionnaire response was created or to which the creation of this record is tightly associated.
    """

    authored: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date and/or time that this set of answers were last changed.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.
    """

    source: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The person who answered the questions about the subject.
    """

    item: typing.Optional[typing.List[QuestionnaireResponseItem]] = pydantic.Field(
        default=None
    )
    """
    A group or question item from the original questionnaire for which answers are provided.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
