# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .uri import Uri
from .questionnaire_item_type import QuestionnaireItemType
from .questionnaire_enable_when import QuestionnaireEnableWhen
from .questionnaire_item_enable_behavior import QuestionnaireItemEnableBehavior
from .canonical import Canonical
from .questionnaire_answer_option import QuestionnaireAnswerOption
from .questionnaire_initial import QuestionnaireInitial
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class QuestionnaireItem(UniversalBaseModel):
    """
    A structured set of questions intended to guide the collection of answers from end-users. Questionnaires provide detailed control over order, presentation, phraseology and grouping to allow coherent, consistent data collection.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    link_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="linkId")
    ] = pydantic.Field(default=None)
    """
    An identifier that is unique within the Questionnaire allowing linkage to the equivalent item in a QuestionnaireResponse resource.
    """

    definition: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    This element is a URI that refers to an [[[ElementDefinition]]] that provides information about this item, including information that might otherwise be included in the instance of the Questionnaire resource. A detailed description of the construction of the URI is shown in Comments, below. If this element is present then the following element values MAY be derived from the Element Definition if the corresponding elements of this Questionnaire resource instance have no value: _ code (ElementDefinition.code) _ type (ElementDefinition.type) _ required (ElementDefinition.min) _ repeats (ElementDefinition.max) _ maxLength (ElementDefinition.maxLength) _ answerValueSet (ElementDefinition.binding) \* options (ElementDefinition.binding).
    """

    code: typing.Optional[typing.List[Coding]] = pydantic.Field(default=None)
    """
    A terminology code that corresponds to this group or question (e.g. a code from LOINC, which defines many questions and answers).
    """

    prefix: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short label for a particular group, question or set of display text within the questionnaire used for reference by the individual completing the questionnaire.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of a section, the text of a question or text content for a display item.
    """

    type: typing.Optional[QuestionnaireItemType] = pydantic.Field(default=None)
    """
    The type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).
    """

    enable_when: typing_extensions.Annotated[
        typing.Optional[typing.List[QuestionnaireEnableWhen]],
        FieldMetadata(alias="enableWhen"),
    ] = pydantic.Field(default=None)
    """
    A constraint indicating that this item should only be enabled (displayed/allow answers to be captured) when the specified condition is true.
    """

    enable_behavior: typing_extensions.Annotated[
        typing.Optional[QuestionnaireItemEnableBehavior],
        FieldMetadata(alias="enableBehavior"),
    ] = pydantic.Field(default=None)
    """
    Controls how multiple enableWhen values are interpreted - whether all or any must be true.
    """

    required: typing.Optional[bool] = pydantic.Field(default=None)
    """
    An indication, if true, that the item must be present in a "completed" QuestionnaireResponse. If false, the item may be skipped when answering the questionnaire.
    """

    repeats: typing.Optional[bool] = pydantic.Field(default=None)
    """
    An indication, if true, that the item may occur multiple times in the response, collecting multiple answers for questions or multiple sets of answers for groups.
    """

    read_only: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="readOnly")
    ] = pydantic.Field(default=None)
    """
    An indication, when true, that the value cannot be changed by a human respondent to the Questionnaire.
    """

    max_length: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="maxLength")
    ] = pydantic.Field(default=None)
    """
    The maximum number of characters that are permitted in the answer to be considered a "valid" QuestionnaireResponse.
    """

    answer_value_set: typing_extensions.Annotated[
        typing.Optional[Canonical], FieldMetadata(alias="answerValueSet")
    ] = pydantic.Field(default=None)
    """
    A reference to a value set containing a list of codes representing permitted answers for a "choice" or "open-choice" question.
    """

    answer_option: typing_extensions.Annotated[
        typing.Optional[typing.List[QuestionnaireAnswerOption]],
        FieldMetadata(alias="answerOption"),
    ] = pydantic.Field(default=None)
    """
    One of the permitted answers for a "choice" or "open-choice" question.
    """

    initial: typing.Optional[typing.List[QuestionnaireInitial]] = pydantic.Field(
        default=None
    )
    """
    One or more values that should be pre-populated in the answer when initially rendering the questionnaire for user input.
    """

    item: typing.Optional[typing.List["QuestionnaireItem"]] = pydantic.Field(
        default=None
    )
    """
    Text, questions and other groups to be nested beneath a question or group.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(QuestionnaireItem)
