# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .instant import Instant
from .uri import Uri
from .provenance_agent import ProvenanceAgent
from .provenance_entity import ProvenanceEntity
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Provenance(BaseResource):
    """
    Provenance of a resource is a record that describes entities and processes involved in producing and delivering or otherwise influencing that resource. Provenance provides a critical foundation for assessing authenticity, enabling trust, and allowing reproducibility. Provenance assertions are a form of contextual metadata and can themselves become important records with their own provenance. Provenance statement indicates clinical significance in terms of confidence in authenticity, reliability, and trustworthiness, integrity, and stage in lifecycle (e.g. Document Completion - has the artifact been legally authenticated), all of which may impact security, privacy, and trust policies.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Provenance"], FieldMetadata(alias="resourceType")
    ] = "Provenance"
    target: typing.List[Reference] = pydantic.Field()
    """
    The Reference(s) that were generated or updated by the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.
    """

    occurred_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurredPeriod")
    ] = pydantic.Field(default=None)
    """
    The period during which the activity occurred.
    """

    occurred_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurredDateTime")
    ] = pydantic.Field(default=None)
    """
    The period during which the activity occurred.
    """

    recorded: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The instant of time at which the activity was recorded.
    """

    policy: typing.Optional[typing.List[Uri]] = pydantic.Field(default=None)
    """
    Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Where the activity occurred, if relevant.
    """

    reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    The reason that the activity was taking place.
    """

    activity: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.
    """

    agent: typing.List[ProvenanceAgent] = pydantic.Field()
    """
    An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place.
    """

    entity: typing.Optional[typing.List[ProvenanceEntity]] = pydantic.Field(
        default=None
    )
    """
    An entity used in this activity.
    """

    signature: typing.Optional[typing.List[Signature]] = pydantic.Field(default=None)
    """
    A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
