# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import typing_extensions
from ...core.serialization import FieldMetadata
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProjectSite(UniversalBaseModel):
    """
    Web application or web site that is associated with the project.
    """

    name: str = pydantic.Field()
    """
    Friendly name that will make it easy for you to identify the site in the future.
    """

    domain: typing.List[str] = pydantic.Field()
    """
    The list of domain names associated with the site. User authentication will be restricted to the domains you enter here, plus any subdomains. In other words, a registration for example.com also registers subdomain.example.com. A valid domain requires a host and must not include any path, port, query or fragment.
    """

    google_client_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="googleClientId")
    ] = pydantic.Field(default=None)
    """
    The publicly visible Google Client ID for the site. This is used to authenticate users with Google. This value is available in the Google Developer Console.
    """

    google_client_secret: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="googleClientSecret")
    ] = pydantic.Field(default=None)
    """
    The private Google Client Secret for the site. This value is available in the Google Developer Console.
    """

    recaptcha_site_key: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="recaptchaSiteKey")
    ] = pydantic.Field(default=None)
    """
    The publicly visible reCAPTCHA site key. This value is generated when you create a new reCAPTCHA site in the reCAPTCHA admin console. Use this site key in the HTML code your site serves to users.
    """

    recaptcha_secret_key: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="recaptchaSecretKey")
    ] = pydantic.Field(default=None)
    """
    The private reCAPTCHA secret key. This value is generated when you create a new reCAPTCHA site in the reCAPTCHA admin console. Use this secret key for communication between your site and reCAPTCHA.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
