# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .procedure_performer import ProcedurePerformer
from .procedure_focal_device import ProcedureFocalDevice
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Procedure(BaseResource):
    """
    An action that is or was performed on or for a patient. This can be a physical intervention like an operation, or less invasive like long term services, counseling, or hypnotherapy.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Procedure"], FieldMetadata(alias="resourceType")
    ] = "Procedure"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this procedure by the performer or other systems which remain constant as the resource is updated and is propagated from server to server.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, order set or other definition that is adhered to in whole or in part by this Procedure.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A reference to a resource that contains details of the request for this procedure.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger event of which this particular procedure is a component or step.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code specifying the state of the procedure. Generally, this will be the in-progress or completed state.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current state of the procedure.
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code that classifies the procedure for searching, sorting and display purposes (e.g. "Surgical Procedure").
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. "Laparoscopic Appendectomy").
    """

    subject: Reference = pydantic.Field()
    """
    The person, animal or group on which the procedure was performed.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this Procedure was created or performed or to which the creation of this record is tightly associated.
    """

    performed_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="performedDateTime")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.
    """

    performed_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="performedPeriod")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.
    """

    performed_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="performedString")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.
    """

    performed_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="performedAge")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.
    """

    performed_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="performedRange")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.
    """

    recorder: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who recorded the record and takes responsibility for its content.
    """

    asserter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who is making the procedure statement.
    """

    performer: typing.Optional[typing.List[ProcedurePerformer]] = pydantic.Field(
        default=None
    )
    """
    Limited to "real" people rather than equipment.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The location where the procedure actually happened. E.g. a newborn at home, a tracheostomy at a restaurant.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    The coded reason why the procedure was performed. This may be a coded entity of some type, or may simply be present as text.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    The justification of why the procedure was performed.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.
    """

    outcome: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The outcome of the procedure - did it resolve the reasons for the procedure being performed?
    """

    report: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    This could be a histology result, pathology report, surgical report, etc.
    """

    complication: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues.
    """

    complication_detail: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="complicationDetail"),
    ] = pydantic.Field(default=None)
    """
    Any complications that occurred during the procedure, or in the immediate post-performance period.
    """

    follow_up: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="followUp")
    ] = pydantic.Field(default=None)
    """
    If the procedure required specific follow up - e.g. removal of sutures. The follow up may be represented as a simple note or could potentially be more complex, in which case the CarePlan resource can be used.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Any other notes and comments about the procedure.
    """

    focal_device: typing_extensions.Annotated[
        typing.Optional[typing.List[ProcedureFocalDevice]],
        FieldMetadata(alias="focalDevice"),
    ] = pydantic.Field(default=None)
    """
    A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.
    """

    used_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="usedReference")
    ] = pydantic.Field(default=None)
    """
    Identifies medications, devices and any other substance used as part of the procedure.
    """

    used_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="usedCode")
    ] = pydantic.Field(default=None)
    """
    Identifies coded items that were used as part of the procedure.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
