# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .practitioner_role_available_time import PractitionerRoleAvailableTime
from .practitioner_role_not_available import PractitionerRoleNotAvailable
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PractitionerRole(BaseResource):
    """
    A specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["PractitionerRole"], FieldMetadata(alias="resourceType")
    ] = "PractitionerRole"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business Identifiers that are specific to a role/location.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this practitioner role record is in active use.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period during which the person is authorized to act as a practitioner in these role(s) for the organization.
    """

    practitioner: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Practitioner that is able to provide the defined services for the organization.
    """

    organization: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The organization where the Practitioner performs the roles associated.
    """

    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Roles which this practitioner is authorized to perform for the organization.
    """

    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Specific specialty of the practitioner.
    """

    location: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The location(s) at which this practitioner provides care.
    """

    healthcare_service: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="healthcareService"),
    ] = pydantic.Field(default=None)
    """
    The list of healthcare services that this worker provides for this role's Organization/Location(s).
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    Contact details that are specific to the role/location/service.
    """

    available_time: typing_extensions.Annotated[
        typing.Optional[typing.List[PractitionerRoleAvailableTime]],
        FieldMetadata(alias="availableTime"),
    ] = pydantic.Field(default=None)
    """
    A collection of times the practitioner is available or performing this role at the location and/or healthcareservice.
    """

    not_available: typing_extensions.Annotated[
        typing.Optional[typing.List[PractitionerRoleNotAvailable]],
        FieldMetadata(alias="notAvailable"),
    ] = pydantic.Field(default=None)
    """
    The practitioner is not available or performing this role during this period of time due to the provided reason.
    """

    availability_exceptions: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="availabilityExceptions")
    ] = pydantic.Field(default=None)
    """
    A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Technical endpoints providing access to services operated for the practitioner with this role.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
