# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .practitioner_gender import PractitionerGender
import datetime as dt
from .practitioner_qualification import PractitionerQualification
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Practitioner(BaseResource):
    """
    A person who is directly or indirectly involved in the provisioning of healthcare.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Practitioner"], FieldMetadata(alias="resourceType")
    ] = "Practitioner"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    An identifier that applies to this person in this role.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this practitioner's record is in active use.
    """

    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(default=None)
    """
    The name(s) associated with the practitioner.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    A contact detail for the practitioner, e.g. a telephone number or an email address.
    """

    address: typing.Optional[typing.List[Address]] = pydantic.Field(default=None)
    """
    Address(es) of the practitioner that are not role specific (typically home address).
    Work addresses are not typically entered in this property as they are usually role dependent.
    """

    gender: typing.Optional[PractitionerGender] = pydantic.Field(default=None)
    """
    Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.
    """

    birth_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="birthDate")
    ] = pydantic.Field(default=None)
    """
    The date of birth for the practitioner.
    """

    photo: typing.Optional[typing.List[Attachment]] = pydantic.Field(default=None)
    """
    Image of the person.
    """

    qualification: typing.Optional[typing.List[PractitionerQualification]] = (
        pydantic.Field(default=None)
    )
    """
    The official certifications, training, and licenses that authorize or otherwise pertain to the provision of care by the practitioner. For example, a medical license issued by a medical board authorizing the practitioner to practice medicine within a certian locality.
    """

    communication: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A language the practitioner can use in patient communication.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
